#include "lmsg/MsgAddr.hh"
//
//   The Solaris 8 header files seem to generate inconsistent code if
//   _POSIX_C_SOURCE is defined!
#if defined(sun) && defined(_POSIX_C_SOURCE)
#undef _POSIX_C_SOURCE
#endif

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>

using namespace lmsg;

//======================================  Destructor
MsgAddr::~MsgAddr(void) {
}

//======================================  Default constructor
MsgAddr::MsgAddr(void) 
  : ip_addr(0), ip_port(0), subprocess(0)
{}

//======================================  Construct from node/port/sub-proc
MsgAddr::MsgAddr(ipaddr_t node, ipport_t port, ipport_t subp) 
{
    ip_addr    = htonl(node);
    ip_port    = htons(port);
    subprocess = htons(subp);
}

//======================================  Construct from a socket address
MsgAddr::MsgAddr(const ipsock_t& sock) {
    setAddr(sock);
}

//======================================  Copy constructor
MsgAddr::MsgAddr(const MsgAddr& sock) {
    ip_addr    = sock.ip_addr;
    ip_port    = sock.ip_port;
    subprocess = sock.subprocess;
}

//======================================  Assignment operator
MsgAddr&
MsgAddr::operator=(const MsgAddr& sock) {
    ip_addr    = sock.ip_addr;
    ip_port    = sock.ip_port;
    subprocess = sock.subprocess;
    return *this;
}

//======================================  Set ip node field
void 
MsgAddr::setIPAddr(ipaddr_t addr) {
    ip_addr = htonl(addr);
}

//======================================  Set ip port field
void 
MsgAddr::setIPPort(ipport_t port) {
    ip_port = htons(port);
}

//======================================  Get the IP address field
MsgAddr::ipaddr_t
MsgAddr::getIPAddr(void) const {
    return ntohl(ip_addr);
}

//======================================  Get the ip port field
MsgAddr::ipport_t
MsgAddr::getIPPort(void) const {
    return ntohs(ip_port);
}

///---->  Note that since the message addresses are copied directly
//        to/from the message data, the SubProcess ID must also be
//        represented internally in network byte ordering.

//======================================  Get the sub-process field
MsgAddr::ipport_t 
MsgAddr::getSubProcess(void) const {
    return ntohs(subprocess);
}

//======================================  Get the sub-process field
void 
MsgAddr::setSubProcess(ipport_t subpr) {
    subprocess = htons(subpr);
}

void 
MsgAddr::getAddr(ipsock_t& sock) const {
    sock.sin_family      = AF_INET;
    sock.sin_addr.s_addr = ip_addr;
    sock.sin_port        = ip_port;
}

void 
MsgAddr::setAddr(const ipsock_t& sock) {
    ip_addr    = sock.sin_addr.s_addr;
    ip_port    = sock.sin_port;
    subprocess = 0;
}
