/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "html/compound.hh"
#include "html/writer.hh"

namespace html {
    class linebreak : public object {
    public:
        linebreak(void);
        virtual ~linebreak(void);
        linebreak* clone(void) const;
        void write(writer& w) const;
    };
}    

//======================================  Construct an empty compound
html::compound::compound(void) {
}

//======================================  Copy a compound object
html::compound::compound(const compound& x) 
  : mAttr(x.mAttr)
{
    for (const_html_iter i=x.mList.begin() ; i != x.mList.end(); i++) {
        addObject(**i);
    }
}

//======================================  Destroy a compound object
html::compound::~compound(void) {
    clear();
}

//======================================  Add a linebreak to the compound
html::object& 
html::compound::lineBreak(void) {
    mList.push_back(new linebreak);
    return *mList.back();
}

//======================================  Remove an object from the compound
void 
html::compound::remObject(const object* p) {
    for (html_iter i=mList.begin(); i != mList.end(); ++i) {
	if (*i == p) {
	    mList.erase(i);
	    return;
	}
    }
}

//======================================  Remove all objects from the compound
void 
html::compound::clear(void) {
    while (!mList.empty()) {
        delete mList.front();
	mList.pop_front();
    }
}


//======================================  Clone an identical compound
html::compound*
html::compound::clone(void) const {
    return new compound(*this);
}

const char*
html::compound::getTag(void) const {
    return reinterpret_cast<const char*>(0);
}

//======================================  Write compound to output file
void 
html::compound::write(writer& out) const {
    if (getTag()) out.tag(getTag(), mAttr);
    out.pushDefault(mAttr);
    for (const_html_iter i=mList.begin() ; i != mList.end() ; i++) {
        (*i)->write(out);
    }
    out.popDefault();
    if (getTag()) out.endTag(getTag());
}

//======================================  linebreak constructors
html::linebreak::linebreak(void) {}

html::linebreak::~linebreak(void) {}

html::linebreak*
html::linebreak::clone(void) const {
    return new linebreak;
}

//======================================  Write linebreak to output file
void 
html::linebreak::write(writer& out) const {
    out.tagNData("br");
}

//======================================  Remove all objects from the compound
void 
html::compound::clearAttr(void) {
    mAttr.clear();
}
