#ifndef __EXTENSIONS__
#define __EXTENSIONS__
#endif
#include <iostream>
#include "framexmit/framesend.hh"
#include "tconv.h"

   using namespace std;
   using namespace framexmit;

   const int bufsize = 20 * 1024 * 1024;
   const int bufnum = sndDefaultBuffers + 2;
   const char* const mcast = "225.0.0.1";
   const char* const net = "10.4.0.0";
   const int port = frameXmitPort;


   typedef 
      struct {
         bool 		inUse;
         char* 		data;
      } buffer;


   int main (int argc, char* argv[])
   {
      // create a couple of buffers
      buffer	bufs[bufnum];
      for (int i = 0; i < bufnum; i++) {
         bufs[i].data = new (nothrow) char [bufsize];
         bufs[i].inUse = false;
         if (bufs[i].data == 0) {
            cout << "Cannot create buffers" << endl;
            return 1;
         }
      }
   
      // open conection
      cout << "open connection to " << mcast << " over " << net << endl;
      frameSend 	out;
      if (!out.open (mcast, net, port)) {
         cout << "open failed" << endl;
         return 1;
      }
   
      // synchronize start with 1 sec boundary
      tainsec_t		start = TAInow();
      while (start % 1000000000 > 10000) {
         start = TAInow();
      }
   
      // send data buffers away
      for (int i = 0;; i++) {
      
      	 // look for a free data buffer
         buffer*	buf = 0;
         for (buffer* b = bufs; b < bufs + bufnum; b++) {
            if (!out.isUsed (b->inUse)) {
               buf = b;
               break;
            }
         }
         if (buf == 0) {
            cout << "Cannot find unused buffer" << endl;
            return 1;
         }
      
      	 // fill data into buffer
         for (int j = 0; j < bufsize / (int)sizeof (int); j++) {
            *((int*)buf->data + j) = j;
         }
      
      	 // send data buffer
         out.send (buf->data, bufsize, &buf->inUse, false, 
                  (unsigned int) (start / 1000000000LL) + i, 1);
      
         // wait for next second
         tainsec_t tw = (i + 1LL) * 1000000000LL - (TAInow() - start);
         if (tw > 0LL) {
            timespec wait;
            wait.tv_sec = tw / 1000000000LL;
            wait.tv_nsec = tw % 1000000000LL;
            nanosleep (&wait, 0);
         }
      
       	 // status message
         double duration = (double) (TAInow() - start) / 1E9;
         cout << "sent " << i << "/" << bufsize/1024/1024 << "MB at " <<
            ((unsigned int) (start / 1000000000LL) + i) % 1000000 << ":1 " <<
            "Rate " << 8*(bufsize / 1048576.) * (i+1) / duration << " MB/s" << 
            " (skip " << out.skipped() << ")" <<  endl;
      }
   
      // wait to finish
      timespec wait = {2, 0};
      nanosleep (&wait, 0);
   
      // close connection
      cout << "close connection" << endl;
      out.close();
      return 0;
   }
