/* Version $Id: gdsndshost.h 6413 2011-04-01 18:05:35Z james.batch@LIGO.ORG $ */

/* This file provides two functions to help determine the correct address and port number of
 * an nds host.  
 *
 * hostPortConnect() connects to a hostname and port and returns a socket value if successful.
 * This would allow a program to verify that the host exists and there is a service available
 * at the port number, using the AF_INET and SOCK_STREAM parameters. Presumably if a socket
 * is created and a connection made, the desired service exists.  The caller must close the
 * socket (using close(socketfd)) if the call is successful.
 * 
 * getNDSHostPort() attempts to determine two hostname:port candidates for an nds host.
 * This is done by assuming that nds:8088 and nds:8088 are valid hostname:port values for
 * the nds host, and modifying those names and port numbers based on the value of the 
 * NDSSERVER environment variable.  If present, the NDSSERVER environment variable value
 * would look like "hostname0:port0,hostname1:port1,...,hostname<n>:port<n>" where all
 * parts of the variable value are optional.  If hostname0:port0 is omitted, the ',' (comma)
 * must be present at the start of the value (",hostname1:port1").  If the hostname is
 * to be omitted but the port number isn't, then the ':' (colon) must be present 
 * (":port0,host1:port1").  If the port number is to be omitted, just skip the ":port" part
 * as in "hostname0,hostname1".  
 */

 /* Connect to a daq server on "host:port".
  * 
  * Parameters: hostname - pointer to string of characters representing the hostname to be 
  *                        connected.
  *             port -     Integer value of port number to connect to on hostname.
  *             host_ip -  pointer to array of characters (at least 256) that will have
  *                        the IPv4 address copied to if the host can be found.
  * Return value: If > 0, the function connected to hostname:port, and the return value is
  *               the fd of the open socket.  The caller must close() this value!
  *               If < 0, indicates an error occurred.
  *			-1 No hostname provided
  *			-2 socket creation failure
  *			-3 Could not set socket options.
  *			-4 Could not resolve hostname to an IP
  *			-5 Connect failed immediately
  *			-6 Connect failed after 4 attempts.
  */
int
hostPortConnect(char *hostname, int port, char *host_ip) ;

/* Parse through the NDSSERVER environment variable if it exists.
 * Ideally, the environment variable contains a comma-separated list
 * of hostname:port values on which nds services might be found. As
 * an example:
 * NDSSERVER=h2nds0:8088,h2nds1:8088,ldas-pcdev1.ligo.caltech.edu:31200
 * 
 * By default, this function will copy "nds" to hostname0, "nds1" to 
 * hostname1, and 8088 to port0, port1.  If the NDSSERVER environment
 * variable is present, it can specifiy alternate values for the nds
 * hostnames and ports.  Using the above example, "h2nds0" will be copied
 * to hostname0, "h2nds1" will be copied to hostname1, and the value 8088
 * will be written to port0 and port1.
 * 
 * For the NDSSERVER value, all parts (hostname0, port0, hostname1, port1)
 * are optional, if not present the default values will be used.
 * A value of "h2nds0,h2nds1" will overwrite the default hostname values
 * while leaving the port numbers unchanged.
 * A value of ":8087" would overwrite port0 with 8087 while leaving the
 * other values unchanged.
 * A value of "h2nds0,:8087" would overwrite hostname0 with h2nds0 and
 * port1 with 8087, leaving hostname1 and port0 as defaults.
 * A value of ",,ldas-pcdev1.caltech.edu:31200" would leave hostname0, port0
 * hostname1, and port1 as their default values.
 * 
 * A limit of 255 characters may be specified for hostnames, and 5 characters 
 * for port numbers (since a port number has a max value of 65535).
 * The return value in the range 0 to 4 is successful.  Anything else,
 * some error occurred.
 *
 * Parameters: hostname0, hostname1 - character pointers to arrays of characters at
 *                                    least 256 characters long.  These arrays will
 *                                    be overwritten.
 *             port0, port1 - Pointers to integers which will have port numbers 
 *                            overwritten.
 */
int
getNDSHostPort(char *hostname0, int *port0, char *hostname1, int *port1) ;

/* The function parseNDSSERVERval performs the same function as getNDSHostPort
 * but does not obtain the NDSSERVER environment variable value first. The calling
 * function must obtain the value and pass a pointer to the value's address to 
 * the function as the first argument.  The function will extract the first two
 * host:port values from the comma-separated list, and modify the address to point
 * to the remainder of the string.  This would be useful if either the first two
 * values are of no interest, or a complete list of values are desired in which case
 * the hostnames and port numbers returned may be combined with the remainder.
 * 
 * As an example, if *str is ",:8085,host3:port3", on return *str will be "host3:port3"
 * and hostname0, port0, hostname1, and port1 can be used to construct a complete
 * list of "nds:8088,nds1:8085,host3:port3".  This could be used to create a 
 * menu of nds hosts.
 * 
 * The str argument must point to memory that can be modified. Note that the comma
 * separating the first two values from the remainder is not included when *str is 
 * modified.
 */
int
parseNDSSERVERval(char **str, char *hostname0, int *port0, char *hostname1, int *port1) ;

