#ifndef __CINT__

#include <iostream>
#include "TSeries.hh"
#include "DVector.hh"
#include "testPak.hh"

using namespace std;

int main(int argc, const char* argv[]) 

#else

void testcwvec(void) 

#endif

{
  testPak t("TestCWVec", cout);

  //------------------------------------  Create the TSeries
  t.startSection("Construct", "Vector constructors");
  t.startTest("Data Constructor", "Create a TSeries with {1,2,3,4}... ");
  Time t0(12345);
  Interval dT(0.25);
  long  len(4);
  float f[4] = {1,2,3,4};
  TSeries ts1(t0, dT, 4, f);
  ts1.setName("Time series #1");
  t.testError(double(ts1.getNSample()), len, 0, "Data length");
  t.testError(ts1.getStartTime(), t0, "Start time");
  t.testError(ts1.refDVect()->capacity(), len, 0, "Capacity");
  t.testVector((const float*)ts1.refData(), f, len, "Data values");
  if (t.testFailed()) {
      cout << "The following TSeries should have length=capacity=4 and "
	   << "Data={1, 2, 3, 4}" << endl;
      ts1.Dump(cout);
  }
  t.endTest();
  t.endSection();

  //------------------------------------  Resize the data
  long lNewSz(6);
  t.startSection("VecSize", "Vector Size Manipulations");
  t.startTest("reserve", "Extend available space to six words");
  ts1.refDVect()->reserve(lNewSz);
  t.testError(ts1.getNSample(), len, 0, "Data length");
  t.testError(ts1.getStartTime(), t0, "Start time");
  t.testError(ts1.refDVect()->capacity(), lNewSz, 0, "Capacity");
  t.testVector((float*)ts1.refData(), f, len, "Data values");
  if (t.testFailed()) {
      cout << "The following TSeries should have length=4, capacity=6 and "
	   << "Data={1, 2, 3, 4}" << endl;
      ts1.Dump(cout);
  }
  t.endTest();
  t.endSection();


  //------------------------------------  Deep copy to a second
  t.startSection("CopyExt", "Copy and extract vectors");
  t.startTest("copy", "Copy by assignment operator");
  const TSeries& ts1c = ts1;
  TSeries ts2(ts1);
  ts2.setName("Time Series #2");
  const TSeries& ts2c = ts2;
  t.testError(ts2.getNSample(), len, 0, "Target length");
  t.testVector((const float*)ts2c.refData(), f, len, "Target Data");
  t.testError(ts1.getNSample(), len, 0, "Original length");
  t.testVector((const float*)ts1c.refData(), f, len, "Original Data");
  t.testError(int(ts2c.refData()), int(ts1c.refData()), 0, "Addresses");
  if (t.testFailed()) {
      cout << "The data and the addresses should be the same." << endl;
      cout << "Address 1 = " << int(ts1c.refData())
	   << " Address 2 = " << int(ts2c.refData()) << endl;
      ts1.Dump(cout);
      ts2.Dump(cout);
  }
  t.endTest();

  //------------------------------------  Extract data
  t.startTest("copy", "Copy by assignment operator");
  TSeries ts3(ts1.extract(t0+2.0*dT, 2.0*dT));
  ts3.setName("Time Series #3");
  t.testError(ts3.getNSample(), 2, 0, "Target length");
  const TSeries& ts3c(ts3);
  t.testVector((const float*)ts3c.refData(), f+2, 2, "Target Data");
  t.testError(ts1.getNSample(), len, 0, "Original length");
  t.testVector((const float*)ts1c.refData(), f, len, "Original Data");
  t.testError(int(ts3c.refData()), int((const float*)ts1c.refData() + 2), 0, 
	      "Addresses");
  if (t.testFailed()) {
      cout << "The data and the addresses should be the same." << endl;
      cout << "Address 1 = " << int((const float*)ts1c.refData() + 2)
	   << " Address 2 = " << int(ts3c.refData()) << endl;
      ts1.Dump(cout);
      ts3.Dump(cout);
  }
  t.endTest();
  t.endSection();

  //------------------------------------  Test Write access
  float diffval(9999);
  t.startSection("WriteAcc", "Write Access");
  t.startTest("Reference", "Write to referece");
  *((float*)ts2.refData() + 2) = diffval;
  t.testDiffer(int(ts2c.refData()), int(ts1c.refData()), 0, 
	       "Addresses should differ");
  t.testVector((const float*)ts1c.refData(), f, len, "Original Data");
  if (t.testFailed()) {
      cout << "The data and the addresses should be the different." << endl;
      cout << "Address 1 = " << int(ts1c.refData())
	   << " Address 2 = " << int(ts2c.refData()) << endl;
      ts1.Dump(cout);
      ts2.Dump(cout);
  }
 
  //------------------------------------  Copy to non-empty array.
  t.startSection("Append", "Test append function");
  t.startTest("Copy", "Copy to non-empty vector");
  ts2 = ts1;
  t.testError(ts2.getNSample(), len, 0, "Target length");
  t.testVector((const float*)ts2c.refData(), f, len, "Target Data");
  t.testError(ts1.getNSample(), len, 0, "Original length");
  t.testVector((const float*)ts1c.refData(), f, len, "Original Data");
  t.testError(int(ts2c.refData()), int(ts1c.refData()), 0, "Addresses");
  if (t.testFailed()) {
      cout << "The data and the addresses should be the same." << endl;
      cout << "Address 1 = " << int(ts1c.refData())
	   << " Address 2 = " << int(ts2c.refData()) << endl;
      ts1.Dump(cout);
      ts2.Dump(cout);
  }
  t.endTest();

  //------------------------------------  Test Append
  t.startTest("Append", "Append one word");
  int rc = ts2.Append(t0+dT*double(len), dT, &diffval, 1);
  t.testError(rc, 0, 0, "Append return code");
  t.testError(ts1.getNSample(), len, 0, "Original length");
  t.testVector((const float*)ts1c.refData(), f, len, "Original data");
  t.testDiffer(int(ts2c.refData()), int(ts1c.refData()), 0, 
	       "Addresses should differ");
  t.testError(ts2.getNSample(), len+1, 0, "Target length");
  t.testVector((const float*)ts2c.refData(), f, len, "Copied data");
  t.testError(ts2.getDouble(len), diffval, 0, "Appended data");
  if (t.testFailed()) {
      cout << "The data and the addresses should be different." << endl;
      cout << "Address 1 = " << int(ts1c.refData())
	   << " Address 2 = " << int(ts2c.refData()) << endl;
      ts1.Dump(cout);
      ts2.Dump(cout);
  }
  t.endTest();

  //------------------------------------  Test Extend
  t.startTest("Extend", "Extend one word");
  rc = ts2.Append(t0+dT*double(len+1), dT, f, len);
  t.testError(rc, 0, 0, "Append return code");
  t.testError(ts2.getNSample(), 2*len+1, 0, "Target length");
  t.testVector(reinterpret_cast<const float*>(ts2c.refData())+len+1, 
	       f, len, "Appended data");
  ts2.ReSize(len);
  t.testError(ts2.getNSample(), len, 0, "Resized length");
  ts2.extend(t0+double(2*len)*dT);
  t.testError(ts2.getNSample(), 2*len, 0, "Target length");

  if (t.testFailed()) {
      cout << "The data and the addresses should be different." << endl;
      cout << "Address 1 = " << int(ts1c.refData())
	   << " Address 2 = " << int(ts2c.refData()) << endl;
      ts1.Dump(cout);
      ts2.Dump(cout);
  }

  t.endTest();

  t.endSection();

  //------------------------------------  Deep copy to a second
  t.startSection("Clear", "Test clear function");
  t.startTest("Clear", "Clear data vector");
  ts1.Clear();
  if (t.testFailed()) {
      cout << "The data should be empty and address shouldn't have moved." 
	   << endl;
      cout << "Address 1 = " << int(ts1c.refData()) << endl;
      ts1.Dump(cout);
  }
  t.endTest();
  t.endSection();
}
