{
cout << "LIGO Root initialization starting." << endl;

//-------------------------------------  Load the shared libraries.
cout << "Loading libraries from ${exec_prefix}/lib" << endl;
gSystem->Load("libgdsbase");
gSystem->Load("libgdscntr");
gSystem->Load("libclient");
gSystem->Load("libframeio");
gSystem->Load("libdmtsigp");
gSystem->Load("libxsil");
gSystem->Load("libgdsevent");
//-------------------------------------  Load graphis if not batch 
if (!gROOT->IsBatch()) {
    gSystem->Load("libligogui");
    gSystem->Load("libdttview");
    gSystem->Load("libgdsplot");
} else {
    cout << "Graphics libraries not loaded: Batch mode." << endl;
}

//--------------------------------------  Set up the include directories.
gInterpreter->AddIncludePath("${prefix}/share/gds/macros");
gInterpreter->AddIncludePath("${prefix}/include");

//--------------------------------------  Create a data access object.
gROOT->LoadMacro("openDacc.cc");
//extern Dacc In;
openDacc();

//--------------------------------------  Create a display canvas.
if (!gROOT->IsBatch()) {
    TCanvas gds("cGDS", "GDS Data Monitor Tool");
}

//--------------------------------------  Load some common functions.
gROOT->LoadMacro("uniqueName.cc");
gROOT->LoadMacro("TPlot.cc");
gROOT->LoadMacro("THist.cc");
gROOT->LoadMacro("Bode.cc");
gROOT->LoadMacro("Spectrum.cc");
gROOT->LoadMacro("DatEnv.hh");
gROOT->LoadMacro("pTrend.cc");

cout << "Root initialization complete" << endl;
}
