#include "Sinc.hh"
#include <iostream>

using namespace std;

namespace generator {

  Sinc::Sinc(void) {
      setTriggerRate(1.0);
      setParameter("A",     1.0);
      setParameter("F",     1.0);
      setParameter("Width", 6.0);
  }

  Sinc::Sinc(double Amp, double Freq, double w)
  {
      setTriggerRate(1.0);
      setParameter("A",     Amp);
      setParameter("F",     Freq);
      setParameter("Width", w);
  }

  Sinc::~Sinc(void) {
  }

  Sinc*
  Sinc::clone(void) const {
      return new Sinc(*this);
  }

  //====================================  Generate sine-gaussian time-series
  void
  Sinc::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {

      //--------------------------------  Get the parameters
      double Ampl  = getNumeric("A");
      double Freq  = getNumeric("F");
      double omega = 2*M_PI*Freq;
      double Width = getNumeric("Width");

      //-------------------------------  Set up to loop
      double xWid  = 2*Width/Freq;
      double xInc  = dT;
      double xLow  = double(t0 - getTrigTime());
      for (int i=0 ; i<N ; ++i) {
	  double x = xLow + i*xInc;
	  if (x + xWid < 0) continue;
	  if (x > xWid) break;
	  double omx = omega*x;
	  if (fabs(omx) < 1e-4) {
	      //------------------------ For small x, use taylor approximation
              //
              //    sin(x) ~ x - x^3/6 + x^5/120 - ...
              //    so for small x,  sin(x) ~ x - x^3/6
              //    and sin(x)/x ~ 1 - x^2/6
              //    at x=1e-4, sin(x)/x ~ 1 - x^2/6 + O(10^-18)
              // 	
	      d[i] = Ampl*(1 - omx*omx/6.0);
	  } else {
	      d[i] += Ampl * sin(omx) / omx;
	  }
      }
  }

  //====================================  Get the full width (2*Width*sigma)
  Interval
  Sinc::getDuration(void) const {
      double Freq  = getNumeric("F");
      double Width = getNumeric("Width");
      return Interval(2*Width/Freq);
  }

} // namespace generator
