#include "GaussNoise.hh"
#include "Time.hh"
#include "constant.hh"
#include "rndm.hh"
#include <math.h>

//-------------------------------------  GaussNoise Constructor.
GaussNoise::GaussNoise(double Freq, const Interval& dT, const Time& t0)
  : mT0(t0), mTc(t0), mFny(Freq)
{
    mFny = Freq;
    mTl  = t0 + dT;
}

//-------------------------------------  Frequency domain template bin.
fComplex 
GaussNoise::Fspace(double Freq, double dF) const {
    double rn = twopi*Rndm();
    return fComplex(::cos(rn), ::sin(rn));
}

//-------------------------------------  Time domain template bin.
double 
GaussNoise::Tspace(const Time& t0) const {
    return Ampl(t0)*Rannor();
}

//-------------------------------------  Get the t0.
Time 
GaussNoise::getT0(void) const {
    return mT0;
}

//-------------------------------------  Get the End time.
Time
GaussNoise::getTEnd(void) const {
    return mTl;
}

//-------------------------------------  Get the Critical time.
Time
GaussNoise::getTc(void) const {
    return mTc;
}

//-------------------------------------  Time versus Frequency.
Time
GaussNoise::TvsF(double f) const {
    return mT0;
}

//-------------------------------------  Waveform Frequency.
double
GaussNoise::freq(const Time& t) const {
    return mFny/2.0;
}

//-------------------------------------  Waveform Phase angle.
double
GaussNoise::phi(const Time& t) const {
    return 0.0;
}

//-------------------------------------  Amplitude.
double 
GaussNoise::Ampl(const Time& t) const {
    return 1.0;
}
