//  Define the swig module name.
%module pygdsdata

//  The following code is copied verbatim to the wrapper file.
//  Note that this code is not passed through CPP
%{
#define SWIG_FILE_WITH_INIT
#include "TSeries.hh"
#include <iostream>
%}

%include "numpy.i"
%init %{
import_array();
%}

//  ANSI C/C++ wrapper declarations.

class Time {
 public:
    Time(unsigned long=0, unsigned long=0);
    ~Time(void);
    double operator-(const Time& t) const;
    Time operator-=(double dt);
    Time operator+=(double dt);
    unsigned long getS(void) const;
    unsigned long getN(void) const;
    double totalS(void) const;
};

Time Now(void);


%apply(int DIM1, double* INPLACE_ARRAY1){(int N, double* vect)}
%apply(int DIM1, double* IN_ARRAY1){(int N, double* ivect)}

class TSeries {
 public:
    typedef unsigned long size_type;
    TSeries(const Time& t0, double dT, int N, double* ivect);
    ~TSeries(void);
    TSeries& operator+=(const TSeries&);
    TSeries& operator-=(const TSeries&);
    // TSeries& operator*=(const TSeries&);
    // TSeries& operator/=(const TSeries&);
    TSeries& operator+=(double);
    TSeries& operator*=(double);
    double operator*(const TSeries&) const;
    int Append(const TSeries&);
    void Dump(void) const;
    void eraseStart(double);
    void extend(const Time&);
    TSeries extract(const Time& t0, double dT) const;
    Time getEndTime(void) const;
    size_type getNSample(void) const;
    Time getStartTime(void) const;
    double getTStep(void) const;
    size_type getData(int N, double* vect);
};
