#ifndef _LIGO_MONACCESS_LMSG_H
#define _LIGO_MONACCESS_LMSG_H
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: monaccess_lmsg						*/
/*                                                         		*/
/* Module Description: class to access monitor data by lmsg inteface	*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 0.1	 23Feb05  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: monaccess_lmsg.html					*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1999.			*/
/*                                                         		*/
/*                                                         		*/
/* Caltech				MIT		   		*/
/* LIGO Project MS 51-33		LIGO Project NW-17 161		*/
/* Pasadena CA 91125			Cambridge MA 01239 		*/
/*                                                         		*/
/* LIGO Hanford Observatory		LIGO Livingston Observatory	*/
/* P.O. Box 1970 S9-02			19100 LIGO Lane Rd.		*/
/* Richland WA 99352			Livingston, LA 70754		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

#include "monapi/monaccess.hh"
#include "MonIndex.hh"
#include "MonClient.hh"
#include "NameClient.hh"


namespace monapi {

/** Class to access monitor data by lmsg interface.
   
    @memo Lmsg monitor access class
    @author Written June 2005 by Daniel Sigg
    @version 1.0
 ************************************************************************/
   class monaccess_lmsg : public monaccess {
   public:
      /// Default constructor
      monaccess_lmsg (const char* server = 0);
      /// Desctructor
      virtual ~monaccess_lmsg();
      /** Get an index of all monitor servers.
          @memo Get monitor index from name server.
          @param list semi-colon delimited list of servers (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getIndex (std::string& list);
      /** Set the monitor data server.
          @memo Set the monitor data server.
          @param server Name of server/monitor 
   	  @return true if successful
       ******************************************************************/
      virtual bool setServer (const char* server);
      /** Get information about a server data object.
          To enumerate over all data objects use the following code:
          \begin{verbatim}
          string name, type, comm;
          for (int n = 0; getServerEntry (n,name,type,comm); ++n) {
             ... // valid name, type and comment
          }
          \end{verbatim}
          @memo Get information about a server data object.
          @param n entry index
          @param name data object name (return)
          @param type data object type (return)
          @param comm data object commnet (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getServerEntry (int n, std::string& name, 
                        std::string& type, std::string& comm);
      /** Get a data object
          @memo Get a data object.
          @param name Name of object
          @param ts Time series object (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getData (const char* name, TSeries* ts);
      /** Get a data object
          @memo Get a data object.
          @param name Name of object
          @param fs Frequency series object (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getData (const char* name, FSeries* fs);
      /** Get a data object
          @memo Get a data object.
          @param name Name of object
          @param fs Frequency spectrum object (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getData (const char* name, FSpectrum* fs);
      /** Get a data object
          @memo Get a data object.
          @param name Name of object
          @param hg Histogram object (return)
   	  @return true if successful
       ******************************************************************/
      virtual bool getData (const char* name, Histogram1* hg);
   
   protected:
      /// Monitor client
      MonClient*	fMC;
      /// Monitor index
      MonIndex*		fIndex;
   };

}

/** Returns a lmsg monitor access object
    @memo Returns a monitor access object.
    @return monaccess object if successful, 0 otherwise
 *************************************************************************/
extern "C" {
   monapi::monaccess* getMonAccessLMSG (void);
}


#endif
