#include <time.h>
#include "monapi/monaccess_lmsg.hh"
#include <iostream>


namespace monapi {

   using namespace std;

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// monaccess_lmsg                                                       //
//                                                                      //
// monitor access by lmsg                                               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   monaccess_lmsg::monaccess_lmsg (const char* server) 
   : monaccess (server), fMC (0), fIndex (0)
   {
   }

//______________________________________________________________________________
   monaccess_lmsg::~monaccess_lmsg()
   {
      if (fIndex) delete fIndex;
      if (fMC) delete fMC;
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getIndex (std::string& list)
   {
      lmsg::NameClient nc;
      lmsg::MsgAddr addr;
      lmsg::NameProcs type = lmsg::p_Monitor;
      //nc.setDebug(1);
      int rc = nc.getIndex (list, addr.getIPAddr(), type);
      if (rc) {
         cerr << "error in nameserver lookup " << rc << endl;
         return false;
      }
      return true;
   }

//______________________________________________________________________________
   bool monaccess_lmsg::setServer (const char* server)
   {
      string s (server ? server : 0);
      string::size_type pos = s.rfind("@");
      if (pos != string::npos) {
         s.erase (pos);
      }
      monaccess::setServer (s.c_str());
      if (fMC) delete fMC;
      if (s.empty()) {
         return true;
      }
      fMC = new MonClient();
      if (fMC == 0) {
         return false;
      }
      return (fMC->setServer (s.c_str()) == 0);
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getServerEntry (int n, std::string& name, 
                     std::string& type, std::string& comm)
   {
      if (!fMC || (n < 0)) {
         return false;
      }
      //fMC->setDebug((lmsg::index_t)1);
      if (!fIndex) {
         fIndex = new MonIndex (*fMC);
         if (!fIndex) {
            return false;
         }
      }
      // not very efficient!
      MonIndex::const_index_iterator iter = fIndex->begin();
      for (int i = 0; (i < n) && (iter != fIndex->end()); ++iter, ++i) {
      }
      if (iter == fIndex->end()) {
         delete fIndex;
         fIndex = 0;
         return false;
      }
      name = fIndex->getName(iter);
      type = fIndex->getType(iter);
      comm = fIndex->getComment(iter);
      return true;
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getData (const char* name, TSeries* ts)
   {
      if (!fMC) {
         return false;
      }
      return (fMC->getData (name, ts) == 0);
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getData (const char* name, FSeries* fs)
   {
      if (!fMC) {
         return false;
      }
      return (fMC->getData (name, fs) == 0);
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getData (const char* name, FSpectrum* fs)
   {
      if (!fMC) {
         return false;
      }
      return (fMC->getData (name, fs) == 0);
   }

//______________________________________________________________________________
   bool monaccess_lmsg::getData (const char* name, Histogram1* hg)
   {
      if (!fMC) {
         return false;
      }
      return (fMC->getData (name, hg) == 0);
   }

}

//______________________________________________________________________________
extern "C" {
   monapi::monaccess* getMonAccessLMSG (void)
   {
      return new monapi::monaccess_lmsg();
   }
}


