/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "MultiList.hh"
#include <fstream>
#include <string>
#include <iostream>
#include <sys/types.h>
#include <dirent.h>
#include <fnmatch.h>

using namespace std;

//======================================  Constructor
MultiList::MultiList(void) {
}

//======================================  Destructor
MultiList::~MultiList(void) {
    mList.clear();
}

//======================================  Specify a data source to be read.
void 
MultiList::addMulti(const char* multinm) {
    if (!multinm || !*multinm) return;
    ifstream inl(multinm);
    long nStartList = mList.size();
    cout << "Processing multi list file: " << multinm << endl;
    string lname;
    while (inl.good()) {
        lname.clear();
        inl >> lname;
	if (!inl) break;
	while (lname.size() > 0 && lname[0] == ' ') lname.erase(0,1);
	int l = lname.size();
	if (l<=0 || lname[0] == '#') continue;
	while (l>0 && (lname[l-1]==' ' || lname[l-1]=='\n'))lname.erase(--l);
	if (l>0) mList.push_back(lname.c_str());
    }
    cout << "        Number of lists added: " << mList.size() - nStartList
	 << " Total data streams: " << mList.size() << endl;
}

//======================================  Specify a data source to be read.
void
MultiList::addSingle(const char* singlenm) {
    if (!singlenm || !*singlenm) return;
    mList.push_back( singlenm );
}

//======================================  Print the list list
std::ostream& 
MultiList::print(std::ostream& out) const {
    if (empty()) return out << "No lists requested." << endl;
    multi_list::size_type N = mList.size();
    for (multi_list::size_type i=0; i < N; i++) {
        out << mList[i] << endl;
    }
    return out;
}
