/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "ProcList.hh"
#include "ProcTable.hh"
#include <sstream>

using namespace trig;
using namespace std;

//======================================  Process list constructor.
ProcList::ProcList(void) {
}

//======================================  Process list destructor.
ProcList::~ProcList(void) {
}

//======================================  Insert process or bump use count.
TrigProc& 
ProcList::insert(const TrigProc& p) {

    //----------------------------------  Look for existing process entry
    count_type N = mProcVect.size();
    for (count_type i=0; i<N; ++i) {
	if (mProcVect[i]._use && mProcVect[i]._proc == p) {
	    mProcVect[i]._use++;
	    return mProcVect[i]._proc;
	}
    }

    //----------------------------------  Create entry (use==1)
    list_entry le(p);
    string ifo = le._proc.getIFOs();
    for (string::size_type i=0; i<ifo.size(); ) {
	if (ifo[i] == ' ') ifo.erase(i, 1);
	else               i++;
    }
    le._proc.setIFOs(ifo);

    //----------------------------------  Look for an unused slot
    count_type slot = N;
    for (count_type i=0; i<N; ++i) {
	 if (!mProcVect[i]._use) {
	     slot = i;
	     break;
	 }
    }

    //----------------------------------  Generate a process id
    ostringstream id;
    id << "process:process_id:" << slot;
    le._proc.setProcessID(id.str());
    if (slot == N) mProcVect.push_back(le);
    else           mProcVect[slot] = le;
    return mProcVect[slot]._proc;
}

//======================================  Decrement process use count.
bool 
ProcList::unuse(const std::string& pid) {
    count_type N = mProcVect.size();
    for (count_type i=0; i<N; ++i) {
	if (mProcVect[i]._use && pid == mProcVect[i]._proc.getProcessID()) {
	    return --(mProcVect[i]._use);
	}
    }
    return false;
}

//======================================  Writer process list to a table
void 
ProcList::put(ProcTable& ptab) const {
    count_type N = mProcVect.size();
    for (count_type i=0; i<N; ++i) {
	if (mProcVect[i]._use) {
	    ptab.addRow(mProcVect[i]._proc);
	}
    }
}
