#ifndef PROCIDENT_HH
#define PROCIDENT_HH

#ifndef __CINT__

//
//   This header file generates a static process identifier.
//
//   To interface a process to the trigger system, the user process
//   must first define the following pre-processor macros:
//       PIDCVSHDR  the cvs "$"Header"$"
//       PIDTITLE   A descriptive title of the program.
//   and then include this file.
//

#ifndef PIDTITLE
#define PIDTITLE (const char*)0
#endif
#include "TrigProc.hh"

extern trig::TrigProc* ProcIdent;

struct proc__Ident {
   proc__Ident() { ProcIdent = new trig::TrigProc (PIDCVSHDR, PIDTITLE); }
} proc__ident_init;
   
#endif  // __CINT
#endif  // PROCIDENT_HH

