/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef MONDATAMSG_HH
#define MONDATAMSG_HH

#include "lmsg/Message.hh"
#include "TSeries.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"
#include "FSeries.hh"
#include "Histogram1.hh"
#include "fSeries/DFT.hh"
#include "fSeries/PSD.hh"
#include "fSeries/ASD.hh"
#include <iosfwd>

namespace lmsg {
    class TransInput;
    class TransOutput;
}

//-------------------------------------  Enumerate monitor data message types
enum {
    mdm_Null=65536,
    mdm_Int,
    mdm_Double,
    mdm_String,
    mdm_TSeries,
    mdm_FSeries,
    mdm_FSpectrum,
    mdm_Request,
    mdm_Index,
    mdm_ReqIndex,
    mdm_NAck,
    mdm_Histogram1 // Histogram1
};


template<class T, unsigned int MsgID>
class MonDataMsg : public lmsg::Message {
public:
    MonDataMsg(void);
    ~MonDataMsg(void);
    MonDataMsg(const char* name, const T& ival);
    MonDataMsg(lmsg::TransInput& istr);
    void setData(lmsg::TransInput& istr) throw(std::runtime_error);
    void getData(lmsg::TransOutput& ostr) const;
    T getValue(void) const;
    const char* getName(void) const;
    lmsg::size_type size(void) const;
    lmsg::MsgHeader::MsgType getType(void) const;

private:
    std::string mName;
    T mValue;
};

//-------------------------------------  Integer message class
typedef MonDataMsg<long,        mdm_Int>       MDM_Int;
typedef MonDataMsg<double,      mdm_Double>    MDM_Double;
typedef MonDataMsg<std::string, mdm_String>    MDM_String;
typedef MonDataMsg<TSeries,     mdm_TSeries>   MDM_TSeries;
typedef MonDataMsg<FSeries,     mdm_FSeries>   MDM_FSeries;
typedef MonDataMsg<FSpectrum,   mdm_FSpectrum> MDM_FSpectrum;
typedef MonDataMsg<Histogram1,  mdm_Histogram1> MDM_Histogram1;  // Histogram1


//-------------------------------------  fSeries: duplicate message ids
typedef MonDataMsg<containers::DFT, mdm_FSeries>   MDM_DFT;
typedef MonDataMsg<containers::ASD, mdm_FSpectrum> MDM_ASD;
typedef MonDataMsg<containers::PSD, mdm_FSpectrum> MDM_PSD;

//-------------------------------------  Data request message
class MDM_Request : public lmsg::Message {
public:
    MDM_Request(void);
    ~MDM_Request(void);
    MDM_Request(const char* name);
    MDM_Request(std::istream& istr);
    const char* getName(void) const;
    lmsg::size_type size(void) const;
    lmsg::MsgHeader::MsgType getType(void) const;
    void setData(lmsg::TransInput& istr) throw(std::runtime_error);
    void getData(lmsg::TransOutput& ostr) const;

private:
    std::string mName;
};

//-------------------------------------  Data request message
class MDM_Index : public lmsg::Message {
public:
    MDM_Index(void);
    ~MDM_Index(void);
    MDM_Index(const std::string& name);
    MDM_Index(std::istream& istr);
    void getIndex(std::string& s) const;
    lmsg::size_type size(void) const;
    lmsg::MsgHeader::MsgType getType(void) const;
    void setData(lmsg::TransInput& istr) throw(std::runtime_error);
    void getData(lmsg::TransOutput& ostr) const;

private:
    std::string mIndex;
};

//-------------------------------------  Index request message
typedef lmsg::HdrOnlyMsg<mdm_ReqIndex> MDM_ReqIndex;
typedef lmsg::HdrOnlyMsg<mdm_NAck>     MDM_NAck;

#endif  //  MONDATAMSG_HH
