#include "AlarmMsg.hh"
#include "lmsg/TransInput.hh"
#include "lmsg/TransOutput.hh"
#include <stdexcept>

using namespace std;
using namespace lmsg;

//=======================================  Alarm data I/O functions
TransOutput& 
operator<<(TransOutput& out, const AlarmData& data) {
    out << data.getMonitor()         << data.getAlarm()
	<< double(data.getTimeout()) << data.getSeverity()
	<< data.getStartTime()       << int(data.getFlags())
	<< data.getDescription()     << data.getParameters()
	<< data.getWebFile()         << data.getMultiMedia()      ;
    return out;
}

TransInput& 
operator>>(TransInput& in, AlarmData& data) throw(runtime_error) {
    string Monitor, ID, desc, params;
    double timeout;
    int severe, flags;
    Time start;
    in >> Monitor >> ID    >> timeout >> severe 
       >> start   >> flags >> desc    >> params;
    data = AlarmData(Monitor, ID, Interval(timeout), severe, desc, params);
    data.setStartTime(start);
    data.jamFlags(flags);
    if (!in.empty()) {
        string webFile, multiMedia;
	in >> webFile >> multiMedia;
	data.setWebFile(webFile);
	data.setMultiMedia(multiMedia);
    }
    return in;
}

TransOutput& 
operator<<(TransOutput& out, const AlarmID& data) {
    out << data.getMonitor() << data.getAlarm();
    return out;
}

TransInput& 
operator>>(TransInput& in, AlarmID& data) throw(runtime_error) {
    string Monitor, ID;
    in >> Monitor >> ID;
    data = AlarmID(ID, Monitor);
    return in;
}

TransOutput& 
operator<<(TransOutput& out, const AlarmHandle& data) {
    out << data.getInt();
    return out;
}

TransInput& 
operator>>(TransInput& in, AlarmHandle& data) throw(runtime_error) {
    in >> data.mHandle;
    return in;
}

TransOutput& 
operator<<(TransOutput& out, const vector<AlarmHandle>& data) {
    int len = data.size();
    out << len;
    for (int i=0 ; i<len ; i++) out << data[i].getInt();
    return out;
}

TransInput& 
operator>>(TransInput& in, vector<AlarmHandle>& data) throw(runtime_error) {
    int len;
    AlarmHandle hint;
    in >> len;
    for (int i=0 ; i<len ; i++) {
	in >> hint;
	data.push_back(hint);
    }
    return in;
}

TransOutput& 
operator<<(TransOutput& out, const pair<AlarmID, int>& data) {
    out << data.first << data.second;
    return out;
}

TransInput& 
operator>>(TransInput& in, pair<AlarmID, int>& data) throw(runtime_error) {
    in >> data.first >> data.second;
    return in;
}

TransOutput& 
operator<<(TransOutput& out, const pair<AlarmHandle, double>& data) {
    out << data.first << data.second;
    return out;
}

TransInput& 
operator>>(TransInput& in, pair<AlarmHandle, double>& data) throw(runtime_error) {
    in >> data.first >> data.second;
    return in;
}

//=======================================  Instanciate templated classes
template <class T, unsigned int MsgID>
void
DataMsg<T,MsgID>::getData(TransOutput& out) const {
    out << mData;
}

template <class T, unsigned int MsgID>
void
DataMsg<T,MsgID>::setData(TransInput& in) throw(std::runtime_error) {
    in >> mData;
}

template class lmsg::DataMsg<AlarmData, almDefine>;
template class lmsg::DataMsg<AlarmID, almGetActive>;
template class lmsg::DataMsg<AlarmID, almGetDefined>;
template class lmsg::DataMsg<AlarmData, almSet>;
template class lmsg::DataMsg<AlarmData, almStatus>;
template class lmsg::DataMsg<AlarmHandle, almReference>;
template class lmsg::DataMsg<AlarmHandle, almAcknowledge>;
template class lmsg::DataMsg<AlarmHandle, almCancel>;
template class lmsg::DataMsg<AlarmHandle, almRequest>;
template class lmsg::DataMsg< std::vector<AlarmHandle>, almActiveReply>;
template class lmsg::DataMsg< std::string, almDefinedReply>;
template class lmsg::DataMsg< std::pair<AlarmID, int>, almSetDisable >;
template class lmsg::DataMsg< AlarmID, almGetTemplate >;
template class lmsg::DataMsg< AlarmID, almRemove >;
template class lmsg::DataMsg< std::pair<AlarmHandle, double>, almProlong >;
