/************************************************************************
 * The following is a collection of wavelet-analysis related routines
 * @ MAR-1998 IoK, EK
 * @ JUN-2001 - ported to C
 * @ APR-2003 - ported to C++, added new functions, 
 *              new class structure - GJM
 ************************************************************************/
#include <cmath>

class Wavelet {

public:

  Wavelet (int samples);        // creates blank data array 
  Wavelet ();                   // default constructor, no data
  Wavelet (double * inputdata, int samples, char datatype); // double data constructor
  virtual ~Wavelet (void);

  // filtering functions:
  
  double getWaveletMax(int scale);
  double getWaveletMax(int scale, int sect, int num_sect);
  int    getWaveletMaxTime(int scale);
  int    getWaveletMaxTime(int scale, int sect, int num_sect);
  int    checkMaxAlign(int *maxtime, int epsilon);
  int    checkNarrowbandAlign(int *maxtime, int epsilon, int minWidth);
  double checkAccuracy(double * inputarray);
  double getAlignMag (double * maxtime);
  double deltaE (double * waveletmax);
  int    hFoc (double * waveletmax);
  
  // private member get/set functions:

  double * getRawArray(void);
  double * getWaveArray(void);
  int      getSize(void);
  int      getScale(int samples);
  virtual const char* getType(void) = 0;

  void setRawArray (double * inputdata, int arraySize);
  void setWaveArray (double * inputdata, int arraySize);
  
  // base function, calls wavelet-specific de/recompostion:
  
  int transform (int direction);
  
protected:
    
  int size;
  int totalScales;

  double *rawarray;
  double *wavearray;

  const double   sqrt2;
  const double   sqrt1_2;
  
  int dec();
  int rec();
  virtual int  dec_1level(int     lsize) = 0;
  virtual int  rec_1level(int     lsize) = 0;

};

class Haar_Wavelet : public Wavelet {

public:
  Haar_Wavelet (int samples);
  Haar_Wavelet ();                   
  Haar_Wavelet (double * inputdata, int samples, char datatype = 'r');
  const char* getType(void);
private:
  int  dec_1level(int lsize);
  int  rec_1level(int lsize);

};

class D4_Wavelet : public Wavelet {

public:
  
  D4_Wavelet(int samples);
  D4_Wavelet ();     
  D4_Wavelet (double * inputdata, int samples, char datatype = 'r');
  const char * getType(void);

private:

  double   D4[4];
    
  int  dec_1level(int  lsize);
  int  rec_1level(int  lsize);

};

class D8_Wavelet : public Wavelet {

public:

  D8_Wavelet(int samples);
  D8_Wavelet ();        
  D8_Wavelet (double * inputdata, int samples, char datatype = 'r');
  const char* getType(void);

private:

  double   D8[8];
  
  int  dec_1level(int lsize);
  int  rec_1level(int lsize);

};

class D16_Wavelet : public Wavelet {
  
public:

  D16_Wavelet(int samples);
  D16_Wavelet ();              
  D16_Wavelet (double * inputdata, int samples, char datatype = 'r');
  const char* getType(void);

private:

  double   D16[16];
  
  int  dec_1level(int lsize);
  int  rec_1level(int lsize);

};
