/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <iostream>
#include <sstream>
#include <string>


#include "xml/XsilTSeries.hh"
#include "html/text.hh"
#include "html/color.hh"

#include "ConfigInfo.hh"

using namespace std;
using namespace xml;

//==============================================================================
//
//  ConfigInfo
//
//==============================================================================

//______________________________________________________________________________
TSeries ConfigInfo::sfTSeries;

//______________________________________________________________________________
//int ConfigInfo::sfData_attn [ kTSMaxNArray ];

//______________________________________________________________________________
ConfigInfo::ConfigInfo () : fThreshold (0), fParam (0), fFilter (0), fLPEFilter(0), 
fSDev(0), fLastNorm(0) {
}

//______________________________________________________________________________
ConfigInfo::ConfigInfo ( const ConfigInfo& conf ) : fThreshold (0), fParam (0),
fFilter (0), fLPEFilter(0), fSDev(0), fLastNorm(0) {
	*this = conf;
}

//______________________________________________________________________________
ConfigInfo::~ConfigInfo () {
	if ( fFilter ) delete fFilter;
	if ( fLPEFilter ) delete fLPEFilter;
}

//______________________________________________________________________________
ConfigInfo& ConfigInfo::operator= (const ConfigInfo& conf) {
	//------ copy config
	fThreshold = conf.fThreshold;
	fFInfo = conf.fFInfo;
	fParam = conf.fParam;
	//fHist = conf.fHist;
	fComment = conf.fComment;

	if (fFilter) delete fFilter;
	if (!conf.fFilter) fFilter = 0;
	else               fFilter = conf.fFilter->clone();

	if (fLPEFilter) delete fLPEFilter;
	if (!conf.fLPEFilter) fLPEFilter = 0;
	else                  fLPEFilter = conf.fLPEFilter->clone();

	fSDev = conf.fSDev;
	fLastNorm = conf.fLastNorm;
	//fSumSDev = conf.fSumSDev;
	//fSumSDevCount = conf.fSumSDevCount;
	//fEventCountHigh = conf.fEventCountHigh;
	//fEventCountLow = conf.fEventCountLow;
	fEvent = conf.fEvent;
        fEventList = conf.fEventList;
	Erasure_Locations = conf.Erasure_Locations;

	return *this;
}

//______________________________________________________________________________
bool ConfigInfo::Init ( const int sfreq ) {

	if ( fFilter ) delete fFilter;
	fFilter = fFInfo->GetFilter( sfreq );

	if ( fLPEFilter ) delete fLPEFilter;
	if ( fFInfo->GetLPEFLength() && fFInfo->GetLPEFTrainPeriod() && fFInfo->GetLPEFTrainLength() ) {
		fLPEFilter = new LPEFilter( fFInfo->GetLPEFLength(), fFInfo->GetLPEFTrainPeriod(), fFInfo->GetLPEFTrainLength() );
	}

	// for ( std::deque<Histogram1>::iterator itr = fHist_buff.begin();
// 	itr != fHist_buff.end(); ++itr ) {
// 		itr->SetTime ( t );
// 	}

// 	Time::ulong_t tS = t.getS();
// 	tS -= tS%60;
// 	fTSRateStartTime = Time(tS, 0);

// 	int arraysize = fRate.size();
// 	int ts_size = fTSRate.getNSample();
// 	Time start_time = fTSRateStartTime - Interval ( (arraysize - 1) * kTSUpdateInt );
// 	if ( fTSRate.getEndTime() < fTSRateStartTime && 
// 	fTSRate.getEndTime() >= start_time ) {
	
// 		std::deque<int>::iterator itr = fRate.begin();
// 		while ( start_time < fTSRate.getStartTime() ) {
// 			++itr;
// 			start_time += Interval (kTSUpdateInt);
// 		}
// 		int data[ ts_size ]; 
// 		fTSRate.getData( ts_size, data );
// 		for ( int i = fTSRate.getBin ( start_time );
// 		i < ts_size; ++i, ++itr ) {
// 			*itr = data[ i ];
// 		}
	
// 	}

// 	fTSRate.Clear();

	return true;
}

//______________________________________________________________________________
bool ConfigInfo::operator== (const ConfigInfo& conf) const {
	return  (fThreshold == conf.fThreshold &&
		fFInfo == conf.fFInfo &&
		fParam == conf.fParam);
}

//______________________________________________________________________________
void ConfigInfo::ClearStat() {
  fSDev = 0;
  fLastNorm = 0;
}
	
//______________________________________________________________________________
void ConfigInfo::Dump () const {
	fThreshold->Dump();
	fFInfo->Dump();
	fParam->Dump();
	cout << fComment << endl;
}

//______________________________________________________________________________
void ConfigInfo::ProcessEvent ( const TSeries& tsold, const float mean ) {
  
    int n = tsold.getBin( tsold.getStartTime() + Interval(1.0) );
    if ( (unsigned int)n != tsold.getNSample () / 2 ) {
	return;
    }

    //   dewarMon seems to be processing overlapping 2-second strides. This
    //   may have been because of the copying rather than cloning IIR Filter
    //   pointers, but in any case, it requires a reset for every stride. The
    //   following will reset quietly as appropriate...
    if (fFilter->getCurrentTime() != Time(0) && 
	tsold.getStartTime() != fFilter->getCurrentTime()) {
	fFilter->reset();
    }

  if ( fLPEFilter ) {
    TSeries tstemp;
    tstemp = fFilter->apply ( tsold );
    fLPEFilter->reset();
    fLPEFilter->train ( tstemp.extract ( tstemp.getStartTime() +
					 Interval(1.0),
					 Interval(1.0) ) );
    fLPEFilter->apply( tstemp, sfTSeries );
  }
  else {
    sfTSeries = fFilter->apply ( tsold );
  }
  
  //const double* data = ((const double*)sfTSeries.refData()) + n;
  double tlow = GetThresholdLow ();
  double data;
  Time currenttime;
  if ( fSDev && tlow ) {
    for ( int i = 0; i < n; ++i ) {
      data = sfTSeries.getDouble( n + i );
      currenttime = tsold.getBinT( n + i );
      if ( fabs(data) > tlow ){ // data above threshold
	double nsigma = fabs(data)/fSDev;
	if ( fEvent.fEventStatus == EventInfo::kNone ){ // event start
	  
	  fEvent.fStartTime   = currenttime;
	  fEvent.fMaxTime     = currenttime;
	  fEvent.fEndTime     = currenttime;
	  fEvent.fMaxData     = nsigma;
	  fEvent.fMaxSDev     = fSDev;
	  fEvent.fMaxMean     = mean;
	  fEvent.fEventStatus = EventInfo::kEvent;
	  fEvent.fEventNPoint = 1;
	} 
	else{ // event continue
	  if ( fParam->fMaxDuration && fEvent.GetDuration() > fParam->fMaxDuration ) {
	    fEvent.Clear(); // terminate event if event duration is greater than max duration.
	    ClearStat(); // clear std. dev. and normalization factor
	  }
	  else {
	    fEvent.fEndTime     = currenttime;
	    fEvent.fEventNPoint++;
	    fEvent.fEventStatus = EventInfo::kEvent;
	    if (nsigma > fEvent.fMaxData){
	      fEvent.fMaxTime = currenttime;
	      fEvent.fMaxData = nsigma;
	      fEvent.fMaxSDev = fSDev;
	      fEvent.fMaxMean = mean;
	    }
	  }
	}
      }
      else {  // data point below threshold
	
	if ( fEvent.fEventStatus == EventInfo::kEvent ) { 
	  fEvent.fEndTime     = currenttime;	
	  fEvent.fEventStatus = EventInfo::kWait;     
	} 
	else if ( fEvent.fEventStatus == EventInfo::kWait ){
	  
	  if ( currenttime - fEvent.fEndTime > fParam->fMinSeparation ){
	    // event is triggered to meta DB, only if its size is greater than high threshold.
	    // if high threshold is zero, trigger to meta DB is disabled.
	    // all events greater than low threshold are used for event rate and histograms.
	    if ( CheckTrigCondition( n ) ) {
	      cout<<"event, start time = " << fEvent.fStartTime <<endl;
		fEventList.push_back( fEvent );
	    }
	    
	    fEvent.Clear ();
	  }
	  
	}
      }
      
    }

    // Erase old events from temporary eventlist
    Time::ulong_t currenttime_sec = currenttime.getS();
    if ( ( currenttime_sec % 3600 ) == 0 ) {
      EventList::iterator itr = fEventList.begin();
      while (itr != fEventList.end()) {
	if ( ( long(currenttime_sec) - ( long(itr->fEndTime.getS()) ) ) > 12 ) {
	  EventList::iterator itr2 = fEventList.erase(itr);
	  itr = itr2;
	}
	else {
	  ++itr;
	}
      }
    }
  }
  
  if ( fEvent.fEventStatus == EventInfo::kNone ) GetRMS ( n );
}

//______________________________________________________________________________
// void ConfigInfo::CoincidentUpdate_low(EventInfo& c_event) {
//   fEventCountLow++;
//   ++(fRate.back());
//   fHist_buff.back().Fill (c_event.fMaxData);

// }

//______________________________________________________________________________
// void ConfigInfo::CoincidentUpdate_high() {
//   fEventCountHigh++;
// }



//______________________________________________________________________________
bool ConfigInfo::CheckAboveHighThreshold_conf(EventInfo coinc_event) {
  if (GetThresholdHigh() && (( coinc_event.fMaxData * coinc_event.fMaxSDev ) > GetThresholdHigh() )) {
    return true;
  }
  else return false;
}


//______________________________________________________________________________
void ConfigInfo::GetOnGoingEvent_conf() {
  fEventList.push_back(fEvent);
}

//______________________________________________________________________________
void ConfigInfo::AddErasure_conf(int loc) {
  std::vector<int>::iterator itr = Erasure_Locations.begin();
  bool cont = true; 
  if (Erasure_Locations.empty()) {
    cont = false;
    Erasure_Locations.push_back(loc);
  } 
  while ((cont) && (itr != Erasure_Locations.end())) {
    if (loc < *itr) {
      ++itr;
    }
    else if (loc == *itr) {
      cont = false;
    }
    else if (loc > *itr) {    
      cont = false;
      Erasure_Locations.insert(itr,loc);
    }
  } 
}


//______________________________________________________________________________
void ConfigInfo::EraseCoincEvents_conf() {
  for (std::vector<int>::iterator itr = Erasure_Locations.begin();
       itr != Erasure_Locations.end(); ++itr) {
    int loc = *itr;
    int n = 0;
    EventList::iterator evitr = fEventList.begin();
    while (n<loc) {
      ++n;
      ++evitr;
    }
    fEventList.erase(evitr);
  }
  Erasure_Locations.clear();
}

//______________________________________________________________________________
void ConfigInfo::GetRMS ( int n ) {
	int step = ( n >= 256 ) ? n / 256 : 1;

	//const double* data = ((const double*)sfTSeries.refData()) + n;

	int count = 0;
	double sum = 0;
	double data;  
	for ( int i = 0; i < n; i += step ){
		data = sfTSeries.getDouble( n + i );
		if (fabs(data) < 65535.0 ){
			sum += data * data;
			++count;
		}
	}

	if ( count ) {
		double sdev = sqrt( sum / count );
		double norm = 1 + kDecay * fLastNorm;
		fSDev = (sdev + fSDev * kDecay * fLastNorm) / norm;
		fLastNorm = norm;

		//	fSumSDev += fSDev;
		//	++fSumSDevCount;
	}

}

//______________________________________________________________________________
double ConfigInfo::GetThresholdLow ( ) const {
	if ( fThreshold->fType == ThresholdInfo::kAbs ) {
		return fThreshold->fLow;
	}

	return (fSDev * fThreshold->fLow);
}

//______________________________________________________________________________
double ConfigInfo::GetThresholdHigh ( ) const {
	if ( fThreshold->fType == ThresholdInfo::kAbs ) {
		return fThreshold->fHigh;
	}

	return fSDev * fThreshold->fHigh;
}

//______________________________________________________________________________
bool ConfigInfo::CheckTrigCondition ( int n ) const {
	// n = sampling frequency
	if ( fParam->fMaxDuration && fEvent.GetDuration() > fParam->fMaxDuration ) 
		return false;

	if ( ( fEvent.GetDuration() > fParam->fMinDuration ) &&
	( fEvent.fEventNPoint > fEvent.GetDuration().GetSecs() * fParam->fMinDensity * n ) ) {
		return true;
	}

	return false;
}

//______________________________________________________________________________
void ConfigInfo::ResetStat ( const char* name, const char* ifo ) {

	ostringstream str;
	str << name;
	//strstream thrsh;
	switch ( fThreshold->fType ) {
		case ThresholdInfo::kAbs:
			{
			str << "_Ta";
			break;
			}
		default:
			{
			str << "_Tr";
			break;
			}
	}
	str << "_" << fThreshold->fLow 
		<< "_" << fThreshold->fHigh;

	if ( !fFInfo->fName.empty() ) {
		str << "_F" << fFInfo->fName;
	}
	else {
		str << "_FNf";
	}

	std::string base = str.str();

	fEvent.fChannel = name;
	fEvent.fIfo = ifo;

	if ( fComment.size() ) {
		fEvent.fComment = fComment;
	}
	else {
		fComment = base;
		fEvent.fComment =  base;
	}



// 	if ( !trend.getName().empty() ) {
// 		trend.addChannel ( fEvent.fComment.c_str() );
// 	}
// 	std::string name_hists = base;
// 	name_hists += "_H2hrs";
// 	std::string name_histl = base;
// 	name_histl += "_H24hrs";
// 	std::string name_ts = base;
// 	name_ts += "_T";

// 	fHistS = fHist->CreateHistogram( name_hists.c_str(), "Number of Std. Dev", "Count" );
// 	fHistL = fHist->CreateHistogram( name_histl.c_str(), "Number of Std. Dev", "Count" );

// 	for ( int i = 0; i < 24; ++i ) {
// 		fHist_buff.push_back ( fHist->CreateHistogram () );
	
// 	}

// 	for ( int i = 0; i < ts_interval; ++i ) {
// 		fRate.push_back( (int) 0 );
// 	}
// 	fTSRate.setName ( name_ts.c_str() );

// 	for ( vector<TSeries>::const_iterator itr = tlist.begin();
// 	itr != tlist.end(); ++itr ) {
// 		if ( strcasecmp ( itr->getName(), name_ts.c_str() ) == 0 ) {
// 			fTSRate = *itr;
// 			break;
// 		}
// 	}

// 	mserv.serveData( name_hists.c_str(), &(fHistS) );
// 	mserv.serveData( name_histl.c_str(), &(fHistL) );
// 	mserv.serveData( name_ts.c_str(), &(fTSRate) );


}

//______________________________________________________________________________
// void ConfigInfo::UpdateHistogram ( const Time& t, Trend& trend ) {
// 	if ( Interval( kHistUpdateInt ) <= t - fHist_buff.back().GetTime() ) {
// 		fHist_buff.pop_front ();
// 		fHist_buff.push_back ( fHist->CreateHistogram () );
// 		fHist_buff.back().SetTime (t);
// 	}

// 	if ( Interval( kTSUpdateInt ) <= t - fTSRateStartTime ) {
// 		if ( !trend.getName().empty() ) {
// 			trend.trendData( fComment.c_str(), t - Interval(30,0), fRate.back() );
// 		}
// 		fTSRateStartTime = t;
// 		fRate.pop_front();
// 		fRate.push_back ( (int) 0 );
// 	}
// }

//______________________________________________________________________________
// void ConfigInfo::OutputLog ( html::table& results ) {
// 	float sdev = (fSumSDevCount) ? fSumSDev/fSumSDevCount : 0;

// 	results.addRow();
// 	int row = results.getNRow () - 1;

// 	html::color clr (0, 0, 150);

// 	// comment
// 	html::text name ( fComment.c_str() );
// 	name.setColor( clr );

// 	// blank
// 	html::text none ( "-" );
// 	none.setColor( clr );

// 	// std. dev
// 	html::text sigma ( sdev );
// 	sigma.setColor( clr );

// 	// max snr
// 	html::text max ( fMax );
// 	max.setColor( clr );

// 	// # of events (all)
// 	html::text count_low ( fEventCountLow );
// 	count_low.setColor( clr );

// 	// # of events (triggered)
// 	html::text count_high ( fEventCountHigh );
// 	count_high.setColor( clr );

// 	results.insertData (row, 0, name ); 
// 	results.refCell (row, 0).setAlign ( "left" );

// 	results.insertData (row, 1, none ); 
// 	results.refCell (row, 1).setAlign ( "center" );

// 	results.insertData (row, 2, html::text ( sigma ) ); 
// 	results.refCell (row, 2).setAlign ( "right" );

// 	results.insertData (row, 3, max ); 
// 	results.refCell (row, 3).setAlign ( "right" );

// 	results.insertData (row, 4, count_low ); 
// 	results.refCell (row, 4).setAlign ( "right" );

// 	results.insertData (row, 5, count_high ); 
// 	results.refCell (row, 5).setAlign ( "right" );

// 	results.insertData (row, 6, none ); 
// 	results.refCell (row, 6).setAlign ( "center" );

// 	fSumSDevCount = 0;
// 	fSumSDev = 0;
// 	fEventCountLow = 0;
// 	fEventCountHigh = 0;
// 	fMax = 0;
// }

//______________________________________________________________________________
void  ConfigInfo::ConfigLog ( std::vector<std::string>& Data ) {
	
	std::string th_type;
	switch (fThreshold->fType)
	{
		case ThresholdInfo::kAbs:
			{
			th_type = "Absolute";
			break;
			}
		default:
			{
			th_type = "Relative";
			break;
			}
	}
	Data.push_back(th_type);
	std::ostringstream fLow_in;
	fLow_in << fThreshold->fLow;
	Data.push_back(fLow_in.str());
	std::ostringstream fHigh_in;
	fHigh_in << fThreshold->fHigh;
	Data.push_back(fHigh_in.str());
	Data.push_back(fFInfo->GetFilterFormulaAll());
	std::ostringstream minsep_in;
	minsep_in << (fParam->fMinSeparation).GetSecs();
	Data.push_back(minsep_in.str());
	std::ostringstream mindur_in;
	mindur_in << fParam->fMinDuration.GetSecs();
	Data.push_back(mindur_in.str());
	std::ostringstream maxdur_in;
	maxdur_in << fParam->fMaxDuration.GetSecs();
	Data.push_back(maxdur_in.str());
	std::ostringstream mindens_in;
	mindens_in << fParam->fMinDensity;
	Data.push_back(mindens_in.str());
	Data.push_back(fComment);



}

//______________________________________________________________________________
// void ConfigInfo::Attention () {
// 	int n = 0;
// 	fHistS.Clear();
// 	fHistL.Clear();
// 	fHistL.SetTime ( fHist_buff.front().GetTime() );
// 	for ( std::deque<Histogram1>::iterator itr = fHist_buff.begin();
// 	itr != fHist_buff.end(); ++itr ) {
// 		fHistL += *itr;
// 		if ( n > 21 ) {
// 			fHistS += *itr;
// 			if ( n == 22 ) fHistS.SetTime ( itr->GetTime() );
// 		}
// 		++n;
// 	}
// 	n = 0;
// 	for ( std::deque<int>::iterator itr = fRate.begin();
// 	itr != fRate.end(); ++itr, ++n ) {
// 		sfData_attn[n] = *itr;
// 	}
// 	fTSRate.setData( Time (int( fTSRateStartTime.getS() - (fRate.size() - 1) * kTSUpdateInt ),
// 		fTSRateStartTime.getN() ),
// 		kTSUpdateInt, sfData_attn, fRate.size() );
// }

// void ConfigInfo::TSSave ( ostream& out ) {
// 	if ( fRate.size() ) {
	
// 		int n = 0;
// 		for ( std::deque<int>::iterator itr = fRate.begin();
// 		itr != fRate.end(); ++itr, ++n ) {
// 			sfData_attn[n] = *itr;
// 		}
// 		fTSRate.setData( Time ( int( fTSRateStartTime.getS() - (fRate.size() - 1) * kTSUpdateInt ),
// 			fTSRateStartTime.getN() ),
// 			kTSUpdateInt, sfData_attn, fRate.size() );
	
	
// 		out << xsilTSeries ( &fTSRate ) << endl;
// 	}
// }
