#ifndef ChannelInfo_HH
#define ChannelInfo_HH

#include <string>
#include <vector>
#include <fstream>

#include "TSeries.hh"
#include "DVector.hh"
#include "MonServer.hh"
#include "DaccAPI.hh"
#include "html/table.hh" 
#include "Trend.hh"

#include "ConfContainer.hh"
#include "LockStatus.hh"
#include "ConfigInfo.hh"

   const static double kMinSDev = 0.0001;

   class ChannelInfo {
   public:
      typedef std::vector<ConfigInfo> ConfigList;

   private:
   
   //----------------------- configuration
   	/// channel name
      std::string fName;
   
   	/// IFO tag
      std::string fIfo;
   
      /// flag to check lock status.
      int fCheckLock;
   
      // float fDecay;
   
   //----------------------- status
   
   	/// pointer to current time series
      TSeries *fTSnew;
   
      /// raw time series
      TSeries fTSold;
   
   	// time series data type. (short, float, ...)
      int fDVType;
   
   	/// sample frequency
      int fSFreq;
   
   	/// # data ponts skipping to get mean ans std. dev
      int fNSkip;
   
   	/// initialization flag
      int fInit;
   
   	/// mean of unfiltered time series
      float fMean;
   
   	/// std. dev. of unfiltered time series
      float fSDev;
   
      float fLastNorm;
   
      int fCount;
   
      float fMeanSum;
   
      int fMeanCount;
   
      float fSDevSum;
   
      int fSDevCount;
   
   //----------------------- ConfigInfo vector
      /// configuration list
      ConfigList fList;


   public:
   
   	/** Constructor.
          @memo Constructor
       ******************************************************************/
      ChannelInfo () : fCheckLock (LockStatus::kInvalid), fTSnew (0), 
      fDVType (DVector::t_short), fSFreq (0), fNSkip (0), fInit (2), 
      fMean (0), fSDev (0), fLastNorm (0), fCount (0), fMeanSum (0), 
      fMeanCount (0), fSDevSum (0), fSDevCount(0) {
      }
   
      ChannelInfo (const ChannelInfo& cinfo) : fCheckLock (LockStatus::kInvalid), 
      fTSnew (0), fDVType (DVector::t_short), fSFreq (0), fNSkip (0), fInit (2), 
      fMean (0), fSDev (0), fLastNorm (0), fCount (0), fMeanSum (0), fMeanCount (0), 
      fSDevSum (0), fSDevCount(0) {
         *this = cinfo;
      }
   
      ~ChannelInfo () ;
   
   //----------------------- configuration
     // bool AddSet (SetInfo& set);
      void AddConfig ( ConfigInfo& conf );
      const char* GetName () const;
      void SetCheckLock ( int checklock );
      bool SetName ( const char* name );
      void Dump () const;
      void ResetStat ();
      void Register ( DaccAPI& dacc );
      void ConfigLog (int which_conf, std::vector<html::table>& tables );
   //----------------------- status
      void getElist( int config, EventList& elist );
     void getCinfo ( int config, ConfigInfo& cinfo );
      int getNConf();
      int Append ( const TSeries& ts );
      bool GetMean ();
      bool GetRMS ();
      bool Init ( const Time& t );
      bool CheckLockStat ( const LockStatus* lock ) const;
      bool IsDataShort () const;
      void ProcessChannel (const DaccAPI& dacc, const LockStatus& lock );
     //      void CoincidentUpdate_low(EventInfo& ch_event, std::size_t ch_config);
     //void CoincidentUpdate_high(std::size_t ch_config);
     void CheckAboveHighThreshold_ch(EventInfo coinc_event, int conf, bool& above);
     void AddErasure_ch(int config, int location);
     void EraseCoincEvents_ch();
     // void OutputLog ( html::table& results );
     // void UpdateHistogram ( const Time& t, Trend& trend );
     //void Attention ();
   
     //void TSSave ( std::ofstream& out );
      void GetOnGoingEvent ();
	  void ClearConfigStat ();
     std::string getFilterFormula (int config);   

      ChannelInfo& operator= (const ChannelInfo& cinfo);
   
   };

#endif
