//#define T_DEBUG

#ifndef TimeMon_HH
#define TimeMon_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "FSpectrum.hh"
#include "TSeries.hh"
#include "Trend.hh"
#include <vector>
#include <iosfwd>
#include "AlarmClient.hh"

class GPSTimer {
public:
  typedef short VecType;
  GPSTimer(const std::string& ramp, const std::string& trend, 
           const std::string& epics, const std::string& alarm, 
           const float MarginalTh, const float ErrorTh, DaccAPI& In);
  ~GPSTimer(void);
  const char*    getRampName(void) const;
  const char*    getTrendName(void) const;
  const char*    getEpicsName(void) const;
  const char*    getAlarmName(void) const;
  const float    getMarginalTh(void) const;
  const float    getErrorTh(void) const;
  const TSeries* getRampSeries(void) const {return mRampSeries;}
  bool           isComplete(void) const;
  void           reset(void);
  void           process(void);
  Time           getTrigTime(void) const;
  double         getRampOff(void) const;
  double         getRampSlope(void) const;
  double         getRampMag0(void) const;
  double         getRampR2(void) const;
  int            getRampFitQ(void) const;

private:
  void     findTrig(const Time& t0);
  double   getRamp(void);

private:
  std::string   mRampChan;
  std::string   mTrend;
  std::string   mEpics;
  std::string   mAlarm;
  float    mMarginalTh;
  float    mErrorTh;
  TSeries* mRampSeries;
  TSeries  mPrev;
  Time     mTrigTime;
  double   fSlope;
  double   fVoltage;
  double   fOffset;
  double   fRsquare;
  int      mRampN;
};

//
//    Data Monitor template class.
//
class TimeMon : public DatEnv, MonServer {
public:
    TimeMon(int argc, const char *argv[]);  // Constructor
    ~TimeMon();                             // Destructor
    void ProcessData(void);
    void Attention(void);
    void Reset(void);
private:
    Trend mTrendSecond;
    Trend mTrendMinute;
    Trend mTrendHour;
    TSeries mRamp;
    AlarmClient   mAlarm;
    std::vector<GPSTimer*> mGPSVect;
    std::vector<int>       mNRamps;
    std::vector<double>    mAvgOff;
    std::vector<double>    mAvgTrg;
    std::vector<double>    mSigOff;
    std::vector<double>    mSigTrg;
    std::vector<double>    mLAvg;
    std::vector<double>    mLSig;
    std::vector<int>       mLN;
    std::string            OF;
};

#endif     //  TimeMon_HH
