#ifndef ShapeMon_HH
#define ShapeMon_HH
//#define GiveGraph
//#define GD_DEBUG

#include "DatEnv.hh"
#include <vector>

class ChannelList {
public:
  typedef short VecType;
  ChannelList(const std::string& chan, 
         const std::string& trend, 
         const std::string& epics, 
			const std::string& alarm, 
         const float MarginalTh, 
			const float ErrorTh);
  ~ChannelList(void);
  const char*    getChannelName(void) const;
  const char*    getTrendName(void) const;
  const char*    getEpicsName(void) const;
  const char*    getAlarmName(void) const;
  const float    getMarginalTh(void) const;
  const float    getErrorTh(void) const;
  
private:
  std::string   mChannel;
  std::string   mTrend;
  std::string   mEpics;
  std::string   mAlarm;
  float    mMarginalTh;
  float    mErrorTh;
};


class ostream;

//
//    Data Monitor template class.
//
class ShapeMon : public DatEnv {
public:
    int MaxFrame;               //  Number of frames I should process
    

    ShapeMon(int argc, const char *argv[]);  // Constructor
    ~ShapeMon();                             // Destructor
    void ProcessData(void);
    float GetSpectrum(TSeries* tx, float* Lm);
private:
    std::vector<ChannelList*> mChannelVect;


};

#endif     //  ShapeMon_HH
