/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef PLANEMONCONFIG_HH
#define PLANEMONCONFIG_HH 

#include <cstdio>
#include <stdexcept>

/** PlaneMonConfig class reads a configuration file containing the 
 * input parameters and passes them to the PlaneMon class DMT monitor.
 * Based on RayleighConfig by Patrick J. Sutton.
 */
class PlaneMonConfig {

public:
    
   PlaneMonConfig( char *configFilename );
	
   ~PlaneMonConfig();
	
   bool CheckParameters();
	
   double Stride;
	
   int fLow;
	
   int fHigh;
	
   double lowThreshold;
	
   double highThreshold;
	
   int channelNumber;
	
   char **channelNames;
	
private:

};


//====================================== Constructor
PlaneMonConfig::PlaneMonConfig( char *configFilename) {

   FILE *in;
   if((in=fopen(configFilename,"r"))==NULL) {
      std::printf("ERROR: cannot open %s. PlaneMon has crashed.",configFilename);
   } else {
      if (std::fscanf(in,"%lf",&Stride) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No stride"); 
      if (std::fscanf(in,"%d",&fLow) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No fLow");
      if (std::fscanf(in,"%d",&fHigh) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No fHigh");
      if (std::fscanf(in,"%lf",&lowThreshold) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No tLow");
      if (std::fscanf(in,"%lf",&highThreshold) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No tHigh");
      if (std::fscanf(in,"%d",&channelNumber) == EOF) 
	 throw std::runtime_error("PlaneMonConfig: No channel count");
      channelNames = new char*[channelNumber];
      for(int i=0; i<channelNumber; i++) {
	 channelNames[i] = new char [64];
	 if (std::fscanf(in,"%s",channelNames[i]) == EOF) 
	    throw std::runtime_error("PlaneMonConfig: Missing channel name");
      }
      fclose(in);
}
}

//====================================== Destructor
PlaneMonConfig::~PlaneMonConfig() {

   for(int i=0; i<channelNumber; i++) {
      delete [] channelNames[i];
   }
   delete [] channelNames;
}

bool PlaneMonConfig::CheckParameters() {

   bool status = true;
    
   if(fLow>fHigh) {
      int temp = fLow;
      fLow = fHigh;
      fHigh = temp;
   }
    
   return status;
}

#endif     //  PLANEMONCONFIG_HH  
