#include "PSLfilter.hh"
#include "Pipe.hh"

using namespace std;

//======================================  Default constructor
PSLfilter::PSLfilter(void)
  : mSettle(0.0) 
{}

//======================================  Data constructor
PSLfilter::PSLfilter(const string& name)
  : mName(name), mSettle(0.0)
{
}

PSLfilter::PSLfilter(const string& name, const Pipe& p, Interval tSettle)
  : auto_pipe(p), mName(name), mSettle(tSettle)
{}

//======================================  Destructor
PSLfilter::~PSLfilter(void) {
}

//======================================  Get filter delay time
Interval
PSLfilter::getDelay(void) const {
    if (null()) return Interval(0.0);
    return (*this)->getTimeDelay();
}

//======================================  Set filter name
void 
PSLfilter::setName(const std::string& name) {
    mName = name;
}

//======================================  Set filter name
void 
PSLfilter::setQuip(const std::string& name) {
    mQuip = name;
}

//======================================  Set settling time
void 
PSLfilter::setSettle(Interval t) {
    mSettle = t;
}
