#ifndef QUICK_SELECT_HH
#define QUICK_SELECT_HH

#include <algorithm>

template <class T>
T quick_select(T arr[], int n) 
{
  const T* median= arr + (n - 1)/2;

  //------------------------------------
  //  Active partition limits.
  register T* low  = arr;
  register T* high = arr + n - 1;
  while (high > low) {
    if (high == low + 1) {  /* Two elements only */
      if (*low > *high) std::swap<T>(*low, *high);
      break;
    }

    // Find median of low, middle and high items; swap into position low
    T* middle = low + (high - low) / 2;

    if (*middle > *high) {
      register T tmp = *high;
      *high = *middle;
      *middle = tmp;
    }
    if (*low    > *high) {
      register T tmp = *high;
      *high = *low;
      *low = tmp;
    }
    if (*middle > *low) {
      register T tmp = *middle;
      *middle = *low;
      *low = tmp;
    }

    // Swap low item (now in position middle) into position (low+1)
    register T* all = low;
    register T aLow = *all++;
    std::swap<T>(*middle, *all);

    // Nibble from each end towards middle, swapping items when stuck
    register T* ahh = high;
    for (;;) {
      while (aLow     > *(++all));
      while (*(--ahh) > aLow);

      if (ahh < all) break;
      std::swap<T>(*all, *ahh) ;
    }

    // Swap middle item (in position low) back into correct position
    *low = *ahh;
    *ahh = aLow;

    // Re-set active partition
    if (ahh <= median) low = all;
    if (ahh >= median) high = ahh - 1;
  }
  return *median;
}
#endif
