/***************************************************************************
    File        : Utils.h
    Description : Implements some usefuls inline functions
 ---------------------------------------------------------------------------
    Begin       : Fri Jul 27 2001
    Copyright   : (C) 2001 by Roberto Grosso
                  All rights reserved
 ***************************************************************************/


/*!
 * \file Types.h
 *  Define some usefull types for numerical operations
 */


#ifndef __TYPES_H
#define __TYPES_H

// Libs
#include <complex>
#include <vector>

namespace gwd {


  //! A complex number with double presicion.
  typedef std::complex<double> Complex;

  //! A vector of doubles for linear algebra.
  typedef std::vector<double> Vector;
  //! A vector of floats.
  typedef std::vector<float> Fvector;
  //! A vector of doubles.
  typedef Vector Dvector;
  //! A vector of integers.
  typedef std::vector<int> Ivector;
  //! A vecotr of complex numbers.
  typedef std::vector<Complex> Cvector;

} // namespace gwd


#endif // __TYPES_H
