// - C++ -
/***************************************************************************
    File        : Chronometer.h
    Description : 

 ---------------------------------------------------------------------------
    Begin       : Tue Sep 10 2002
    Author(s)   : Roberto Grosso
 ***************************************************************************/

#ifndef __CLOCK_H
#define __CLOCK_H


/*
 * The Class "Time"
 * -----------------
 *
 * Description  :   This class is based on the system call times() and is
 *                  designed to measure cpu and wallclock time of function
 *                  calls.
 *
 * Date:            4.11.1993
 *
 */

// #include <sys/types.h>
// #include <sys/times.h>
// #include <sys/param.h>
// #include <time.h>
#include <ctime>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <string.h>


namespace msr {

class Clock {
public:
  // Constructors
  Clock() : startime(0),endtime(0) { }

  // Destructor
  virtual ~Clock() {}

  // Member Functions
  void start(void) {
      startime = clock();//times(&before);
  }
  void stop(void) {
      endtime = clock();//times(&after);
  }
  inline void print(const char* title);

private:
  //struct tms before, after;
  clock_t startime, endtime;
  clock_t utime, stime;
};


//===============================================================================================
//
//  INLINE FUNCTIONS
//
//===============================================================================================
// Description
//
inline void
Clock::print(const char* title)
{
  double wallclok_time, clock_tick;
  
  wallclok_time = static_cast<double>(endtime - startime) /  static_cast<double>(CLOCKS_PER_SEC);
  clock_tick    = (endtime - startime);

  std::cout << title
    << '\n'
    << "--------------------------------------------------"
    << '\n'
    << "|    Wall clock time (sec)  |    Clock Ticks     |"
    << '\n'
    << "--------------------------------------------------"
    << '\n'
    << '|'
    << std::setw(27)
    << std::setprecision(6)
    << wallclok_time
    << '|'
    << std::setw(20) 
    << std::setprecision(6)
    << clock_tick
    << '|'
    << '\n';
}


} // namespace msr
#endif /* __CLOCK_H */
