// $Id: LIGOLwMon.hh 4254 2006-02-18 01:07:39Z duncan.brown $

#include "DMTServer.hh"
#include "TSeries.hh"
#include "FixedLenTS.hh"
#include "TriggerFiles.hh"
#include <string>
#include <map>

class LIGOLwMon : public DMTServer {
public:
  LIGOLwMon(int argc, const char* argv[]);
  ~LIGOLwMon(void);
  void ProcessData(const Time& t);
private:

  // name of the monitor
  std::string mMonName;

  // update parameters
  Interval mDelay;              // time shift for testing
  Interval mStep;               // dt for time series
  Time mLastUpdate;             // time of last update
  Interval mLength;             // length of time series
  TriggerFiles mTrigFiles;      // input trigger files

  // data to server to dmt viewer
  FixedLenTS mTS_time;          // analyzed data from segment table
  FixedLenTS mTS_number;        // number of triggers
  FixedLenTS mTS_amp_mean;      // mean trigger amplitude
  FixedLenTS mTS_amp_max;       // max trigger ampllitude
  FixedLenTS mTS_amp_min;       // min trigger amplitude
  FixedLenTS mTS_cnf_mean;      // mean trigger confidence
  FixedLenTS mTS_cnf_max;       // max trigger confidence
  FixedLenTS mTS_cnf_min;       // min trigger confidence
  FixedLenTS mTS_frq_mean;      // mean trigger frequency
  FixedLenTS mTS_frq_max;       // max trigger frequency
  FixedLenTS mTS_frq_min;       // min trigger frequency

  // multimap containing column name and pointer to time series data
  typedef struct
  tag_tsdatum_t
  {
    float* mean;
    float* max;
    float* min;
  }
  tsdatum_t;
  
  typedef std::map< std::string, tsdatum_t > mmts_t;
  mmts_t mOutputSeries;
};
