#include "xsil/param.hh"
#include "xsil/Xwriter.hh"
#include "PConfig.h"
#ifdef __GNU_STDC_OLD
#include <gnusstream.h>
#else
#include <sstream>
#endif

using namespace std;
using namespace xsil;

//======================================  Null constructor
param::param(void) {
}

//======================================  String data constructor
param::param(const char* Name, const char* Type, const char* Unit, 
		   const char* Value)
  : xobj(Name, Type)
{
    setUnit(Unit);
    setValue(Value);
}

//======================================  Numberic data constructor
param::param(const char* Name, const char* Unit, double Value)
  : xobj(Name, "double") 
{
    setUnit(Unit);
    setValue(Value);
}

//======================================  Numberic data constructor
param::param(const char* Name, const char* Unit, int Value)
  : xobj(Name, "int") 
{
    setUnit(Unit);
    setValue(Value);
}

//======================================  Destructor
param::~param(void) {
}

//======================================  Write parameter to an XML file
void
param::Spew(Xwriter& xout) const {
    int   nattr=2;
    const char* attnames[]={"Name","Type",0 , 0};
    const char* attstrings[]={getName(), getType(), 0, 0};

    //---------------------------------- set the unit attribute
    if (!mUnit.empty()) {
        attnames[nattr] = "Unit";
	attstrings[nattr] = mUnit.c_str();
	nattr++;
    }

    //----------------------------------  Spew the value
    xout.Tag(getObjType(), nattr, attnames, attstrings);
    xout.text(mValue);
    xout.endTag(getObjType());
}

//--------------------------------------  Get the object type
param* 
param::Clone(void) const {
    return new param(getName(), getType(), getUnit(), getValue());
}

//--------------------------------------  Get the object type
const char* 
param::getObjType(void) const {
    return "Param";
}

//--------------------------------------  Get parameter units
const char* 
param::getUnit(void) const {
    return mUnit.c_str();
}

//--------------------------------------  Get parameter value
const char* 
param::getValue(void) const {
    return mValue.c_str();
}

//--------------------------------------  Set the parameter units
void 
param::setUnit(const char* Unit) {
    if (Unit) mUnit = Unit;
}

//--------------------------------------  Set parameter value to a string.
void 
param::setValue(const std::string& Value) {
    // setType("string");
    setValue(Value.c_str());
}

//--------------------------------------  Set parameter to a double value.
void 
param::setValue(double Value) {
    ostringstream out;
    long v = long(Value);
    if (v == Value) out << v;
    else            out << Value;
    setValue(out.str());
    setType("double");
}

//--------------------------------------  Give parameter a numeric value.
void 
param::setValue(int Value) {
    ostringstream out;
    out << Value;
    setValue(out.str());
    setType("int");
}

//--------------------------------------  Give parameter a numeric value.
void 
param::setValue(unsigned int Value) {
    ostringstream out;
    out << Value;
    setValue(out.str());
    setType("int");
}

//--------------------------------------  Set a character value.
void 
param::setValue(const char* Value) {
    if (Value) mValue = Value;
}


