#ifndef _SMSTREAM_H_
#define _SMSTREAM_H_
//
//   Shared memory stream class
//
/**  Shared memory stream class.
  *  This class provides a stream-like interface to the shared memory
  *  buffer manager.
  */
class SMstream : public streambuf {
  public:
    SMstream(const char *partition, ios::openmode mode);
    SMstream* open(const char *partition, ios::openmode mode);
    streamsize sys_read(char *buf, streamsize length);
    streamsize sys_write(const char *buf, streamsize length);
    streamsize sys_seek(streamoff offset, _seek_dir direction);

};
#endif  //  _SMSTREAM_H_
