#include "html/text.hh"
#include "html/color.hh"
#include "html/font.hh"
#include "html/writer.hh"
#include "Time.hh"
#include "PConfig.h"
#include <cstring>
#ifdef __GNU_STDC_OLD
#include <gnusstream.h>
#else
#include <sstream>
#endif

using namespace std;
using namespace html;

//====================================== Replace strings
static void
replaceall(std::string& s, const char* from, const char* to) {
    string::size_type lto   = strlen(to);
    string::size_type lfrom = strlen(from);
    for (string::size_type i=0; (i=s.find(from, i)) != s.npos; i += lto) {
	s.replace(i, lfrom, to);
    }
}

//====================================== Construct an empty test object
text::text(void) {
}

//======================================  Copy constructor
text::text(const std::string& x) {
    addText(x);
}

//======================================  Copy constructor
text::text(double x) {
    *this << x;
}

//======================================  Copy constructor
text::text(const Time& x, const char* fmt) {
    char str[64];
    *this << std::string(TimeStr(x, str, fmt));
}

//======================================  Destroy a text object
text::~text(void) {
}

//======================================  Clone a text object
text* 
text::clone(void) const {
    return new text(*this);
}

//======================================  Write the object to an html file
void 
text::write(writer& out) const {
  // cout << "The font is: "<< mAttr.getFont().getFace() << endl;
    textAttr diffAttr(mAttr);
    diffAttr.suppress(reinterpret_cast<const textAttr&>(out.refDefault()));
    if (diffAttr.isDefault()) {
	out.text(mText);
    } else {
        out.tag("font", diffAttr);
	out.text(mText);
	out.endTag("font");
    }
}

//======================================  Replace the text
void 
text::insertText(const std::string& txt) {
    mText.erase();
    addText(txt);
}

//======================================  Append a text string
void 
text::addText(const std::string& txt) {
    std::string temp(txt);
    replaceall(temp, "<", "&lt;");
    mText += temp;
}

//======================================  Append a text string
text& 
text::operator<<(const std::string& txt) {
    addText(txt);
    return *this;
}

//======================================  Append a text string
text& 
text::operator<<(double x) {
    ostringstream s;
    s << x;
#ifdef __GNU_STDC_OLD
    s << ends;
#endif
    mText += s.str();
    return *this;
}

//======================================  Append a text string
text&
text::setColor(const color& colr) {
    mAttr.setColor(colr);
    return *this;
}

//======================================  Append a text string
text&
text::setFont(const font& Font) {
    mAttr.setFont(Font);
    return *this;
}

//======================================  Append a text string
text&
text::setSize(const size& Size) {
    mAttr.setSize(Size);
    return *this;
}

