/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_SIZE_HH
#define HTML_SIZE_HH

#include "html/Attrib.hh"
#include <string>

namespace html {
    class writer;

    /**  Class size contains text size attributes.
      *  @memo Text size attribute.
      *  @author John Zweizig
      *  @version 1.1; Last modified March 3,2008
      *  @ingroup IO_html
      */
    class size : public attrib {
    public:
	/**  Construct a size specifier.
	  *  @brief Constructor.
	  *  @param Size Size value
	  */
	size(int Size=0);

	/**  Destroy a Size attribute
	  *  @brief Destructor.
	  */
	~size(void);

	/**  Clone the asize attribute.
	  *  @brief Create an identical attribute object.
	  *  @return Pointer to an identical attibute object.
	  */
	size* clone(void) const;

	/**  Test whether the attribute has the default value.
	  *  @brief Test if default.
	  *  @return True if the attribute has the default value.
	  */
	bool isDefault(void) const;

	/**  Print the suze attribute to the specified writer.
	  *  @brief Write the size attribute.
	  *  @param w Write to which the attribute is written.
	  */
	void putAttr(writer& w) const;

	/**  Restore the size attribute to its default value.
	  *  @brief Set default value.
	  */
	void setDefault(void);

	/**  Set the size to a relative value.
	  *  @brief Set a relative size.
	  *  @param delta Font size increment.
	  */
	void setRelative(int delta);

	/**  Set the size attribute to an absolute value.
	  *  @brief Set absolute size value.
	  *  @param Size Size value.
	  */
	void setSize(int Size);

	/**  Test if the size attribute is equal to the specified value.
	  *  @brief Test if sizes are the same.
	  *  @param x Size attribute to be compared.
	  *  @return True if sizes are equal. 
	  */
	bool operator==(const size& x) const;

    private:
	enum {kDefault, kPoints, kDelta} mType;
	int mSize;
    };
}

inline bool
html::size::operator==(const size& x) const {
    return (mType == x.mType) && (mType == kDefault || mSize == x.mSize);
}

#endif //  HTML_SIZE_HH
