/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_HLINE_HH
#define HTML_HLINE_HH

#include "html/object.hh"
#include "html/Attrib.hh"
#include <string>

namespace html {
  class writer;

  /**  The HLINE class represents a Horizontal Line object. The hline
    *  object contains a width attribute which is set to 100\% by default.
    *  @memo Horizontal line object.
    *  @author J. Zweizig
    *  @version 1.0; Modified May 29, 2001
    *  @ingroup IO_html
    */
  class hline : public object {
  public:
    /**  Construct an empty hline.
      *  @memo Default constructor.
      */
    hline(void);

    /**  Construct a hline with the specified width.
      *  @memo Data constructor.
      *  @param wid Text describing the hline width.
      */
    hline (const std::string& wid);

    /**  Destroy the hline object.
      *  @memo Destructor.
      */
    ~hline(void);

    /**  Create an identical hline object and return a pointer.
      *  @memo Clone the hline object.
      *  @return Pointer to the hline clone.
      */
    hline* clone(void) const;

    /**  Write the horizontal line to the specified html writer.
      *  @memo Write the hline.
      *  @param out HTML write to which the line is to be written.
      */
    void write(writer& out) const;

    /**  Set the width (horizontal dimension) of the line to the specified 
      *  value.
      *  @memo Set the hline width.
      *  @param w New hline width.
      */
    void setWidth(const std::string& w);

    /**  Set the thickness of the horizontal line to the specified value.
      *  @memo Set the hline thickness.
      *  @param w New hline size.
      */
    void setSize(const std::string& w);
  private:
    attList mAttr;
  };
}

#endif  // HTML_HLINE_HH
