/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <time.h>
#include <cstring>
#include "FrameF.hh"
using namespace std;

FrameF::FrameF(istream& In) 
  : mIn(In), mHeaderOK(false), mOffset(0), mHdrSz(8)
{
    if (!isOK()) return;
}

FrameF::~FrameF(void) {
    // mIn.close();
}

void
FrameF::ReadHeader(void) throw(BadFile) {
    if (!isOK()) throw BadFile("No input file");
    mIn.read(mData, sizeof(mData));
    if (strcmp(mData, "IGWD")) throw BadFile("File is not IGWD");
    int i(1);
    bool Bigend = !*(char*)&i;
    mSwap     = (( Bigend && (mData[12] == 0x34)) || 
		 (!Bigend && (mData[12] == 0x12)));
    mVersion  = mData[5];
    if (mVersion >= 8) {
        mHdrSz = sizeof(int8_t) + 1 + 1 + sizeof(int4_t);
    } else if (mVersion >= 6) {
        mHdrSz = sizeof(int8_t) + sizeof(int2_t) + sizeof(int4_t);
    } else {
        mHdrSz = sizeof(int4_t) + sizeof(int2_t) + sizeof(int2_t);
    }
    mHeaderOK = true;
}

bool
FrameF::NxStruct(void) throw(BadFile) {

    //----------------------------------  Read the header if not done yet.
    if (!mHeaderOK) ReadHeader();

    //----------------------------------  Skip remainder of current structure
    if (mOffset) {
        int left = mSHdr.length - mOffset;
	if (left) Skip(left);
    }

    //----------------------------------  Read the data, swap if necessary
    mOffset = 0;
    if (mVersion >= 8) {
        mSHdr.length   = getLong();
	mSHdr.chksm    = getChar();
	mSHdr.ID       = getChar();
	mSHdr.Instance = getInt();
    } else if (mVersion >= 6) {
        mSHdr.length   = getLong();
	mSHdr.chksm    = 0;
	mSHdr.ID       = getShort();
	mSHdr.Instance = getInt();
    } else {
        mSHdr.length   = getInt();
	mSHdr.chksm    = 0;
	mSHdr.ID       = getShort();
	mSHdr.Instance = getShort();
    }
    if (mSHdr.length < 8) throw BadFile("Invalid length");
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    return true;
}

int
FrameF::getInt(void) throw (BadFile) {
    int4_t a;
    mIn.read((char*)&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    if (mSwap) {
        int4_t b(a);
	char* from = (char*) (&b + 1);
	char* to   = (char*) &a;
	for (unsigned int i=0 ; i<sizeof(a) ; i++) *to++ = *--from;
    }
    return a;
}

char
FrameF::getChar(void) throw (BadFile) {
    char a;
    mIn.read(&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    return a;
}

long
FrameF::getLong(void) throw (BadFile) {
    int8_t a;
    mIn.read((char*)&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    if (mSwap) {
        int8_t b(a);
	char* from = (char*) (&b + 1);
	char* to   = (char*) &a;
	for (unsigned int i=0 ; i<sizeof(a) ; i++) *to++ = *--from;
    }
    return a;
}

void
FrameF::getLink(StrLink& link) throw(BadFile) {
    link.ID       = getShort();
    if (mVersion >= 6) link.Instance = getInt();
    else               link.Instance = getShort();
}

float
FrameF::getFloat(void) throw (BadFile) {
    float a;
    mIn.read((char*)&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    if (mSwap) {
        float b(a);
	char* from = (char*) (&b + 1);
	char* to   = (char*) &a;
	for (unsigned int i=0 ; i<sizeof(a) ; i++) *to++ = *--from;
    }
    return a;
}

short
FrameF::getShort(void) throw (BadFile) {
    int2_t a;
    mIn.read((char*)&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    if (mSwap) {
        int2_t b(a);
	char* from = (char*) (&b + 1);
	char* to   = (char*) &a;
	for (unsigned int i=0 ; i<sizeof(a) ; i++) *to++ = *--from;
    }
    return a;
}

string
FrameF::getString(void) throw (BadFile) {
    short len = getShort();
    char* str = new char[len];
    mIn.read(str, len);
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += len;
    string a(str);
    delete str;
    return a;
}

double 
FrameF::getDouble(void) throw (BadFile) {
    double a;
    mIn.read((char*)&a, sizeof(a));
    if (mIn.eof()) throw BadFile("Unexpected EOF");
    mOffset += sizeof(a);
    if (mSwap) {
        double b(a);
	char* from = (char*) (&b + 1);
	char* to   = (char*) &a;
	for (unsigned int i=0 ; i<sizeof(a) ; i++) *to++ = *--from;
    }
    return a;
}

void 
FrameF::Seek(int off, ios::seekdir mode) {
    mIn.seekg(off, mode);
    mOffset = 0;
}

void 
FrameF::Skip(int off) {
    mIn.seekg(off, ios::cur);
    mOffset += off;
}

