
#include "framefast/framefast.hh"
#include "framedir.hh"
#include "Time.hh"
#include <stdlib.h>
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <vector>

   using namespace framefast;
   using namespace std;



   int main (int argc, char** argv)
   {
      // parse cmd line arguments
      int 		c;
      extern int	optind;	
      int		errflag = 0;
      vector<string> filenames;
      while ((c = getopt (argc, argv, "h")) != EOF) {
         switch (c) {
            case 'h':
               {
                  errflag = 1;
                  break;
               }
         }
      }
      if (errflag || (argc <= 1)) {
         cout << "usage: framedump 'framefile'" << endl;
         exit (0);
      }
      for (int i = optind; i < argc; i++) {
         filenames.push_back (argv[i]);
      }
   
      // add filenames to frame dir
      FrameDir fdir;
      for (vector<string>::iterator i = filenames.begin(); 
          i != filenames.end(); ++i) {
         fdir.add (i->c_str(), true);
      }
   
      // dump frame contents
      for (FrameDir::file_iterator i = fdir.begin(); i != fdir.end(); i++) {
         string file = i->getFile();
         framereader fr;
         if (fr.loadFile (file.c_str())) {
            cout << "File (" << i->getStartGPS() << "): " << file << endl;  
            cout << fr << endl << endl;
         }
      }
   
      return 0;
   }
