//
// $Id: StdRange.hh 6619 2012-03-12 23:58:12Z john.zweizig@LIGO.ORG $
//
// Author: David Chin <dwchin@umich.edu>
//
//         2477 Randall Lab, Univ. of Michigan
//         500 E. University Ave.
//         Ann Arbor, MI 48109
//         +1-734-764-5146
//         +1-734-730-1274
//
// Written based on idea by K. Riles <kriles@umich.edu>

#ifndef OSCSTDRANGE_HH
#define OSCSTDRANGE_HH

#include "osc/OperStateCond.hh"
#include "FSeries.hh"
#include "FSpectrum.hh"


namespace osc
{
    //
    // STDRANGE
    //
    class StdRange
        : public OperStateCond
    {
    public:
        StdRange(DaccAPI          *access,
                 std::ostream        *outstream,
                 std::string     chanName,  // name of assoc. channel
                 osc::IntParMap &intparams,
                 osc::DblParMap &dblparams,
                 int debug = 0);

        virtual ~StdRange() {};

        virtual bool satisfied();

    private:
        /** {\tt stdrange} has two parameters.  This OSC is
         * satisfied if the STD of the time series data is between
         * {\tt lo} and {\tt hi}
         * \begin{enumerate}
         *    \item {\bf {\tt lo}} STD lower limit
         *    \item {\bf {\tt hi}} STD upper limit
         * \end{enumerate}
         */
    };

} // namespace osc

#endif // !defined OSCSTDRANGE_HH
