#ifndef __CINT__
#include "Dacc.hh"
#include "TSeries.hh"
#include "TString.h"
#include "TCanvas.h"
#include "TPad.h"
#include "TH1.h"

extern Dacc In;
extern TCanvas gds;
#endif

void 
pTrend(const char* channel, const char* file=0, const Time& start=Time(0), 
       double Tint=0.0);

void 
pTrend(const char* channel, const char* file, const Time& start, double Tint) {
    Dacc* tIn = &In;
    if (file) {
        tIn = new Dacc;
	tIn->setTOCMode(false);
	tIn->addFile(file);
	tIn->seek(start);
    } else {
        tIn->synch();
    }
    if (Tint == 0.0) Tint = tIn->getDt();
    tIn->setStride(Tint);
    TString name(channel);
    TSeries *meanTS(0), *minTS(0), *maxTS(0), *countTS(0), *rmsTS(0);
    tIn->addChannel( (name+".mean").Data(), 0, &meanTS);
    tIn->addChannel( (name+".min").Data(),  0, &minTS);
    tIn->addChannel( (name+".max").Data(),  0, &maxTS);
    tIn->addChannel( (name+".n").Data(),    0, &countTS);
    tIn->addChannel( (name+".rms").Data(),  0, &rmsTS);
    int rc = tIn->fillData(Interval(0.0));
    if (rc) cout << "Error in fillData: " << rc << endl;
    // TPlot(rmsTS);

    //----------------------------------  Set up the pad
    gds.cd();
    gds.Clear();
    TPad* xPad = new TPad("xPad", "Trend Pad", 0, 0.0, 1, 1);
    xPad->Draw();
    xPad->cd();

    //----------------------------------  Get the glitch trend
    Time tLow  = meanTS->getStartTime();
    Time tHigh = meanTS->getEndTime();
    int  nStep = meanTS->getNSample();
    double dT = double(tHigh-tLow);

    float* pData  = new float[nStep];
    float* pCount = new float[nStep];
    float* pRMS   = new float[nStep];

    TH1F xHist("xHist", (name+(" Trend")), nStep, 0.0, dT);
    meanTS->getData(nStep, pData);
    countTS->getData(nStep, pCount);
    rmsTS->getData(nStep, pRMS);
    double mean, err;
    for (int i=0 ; i<nStep ; i++) {
        if (pCount[i]) {
	    mean = pData[i];
	    err  = (pRMS[i] * pRMS[i] - mean * mean)/pCount[i];
	    if (err < 0.0) err = 0.0;
	    xHist.SetBinContent(i+1, mean);
	    xHist.SetBinError(i+1, TMath::Sqrt(err));
	}
    }
    delete[] pCount;
    delete[] pRMS;
    double xMin = minTS->getMinimum();
    double xMax = maxTS->getMaximum();
    double xEdge = 0.1* (xMax - xMin);
    xHist.SetMinimum(xMin-xEdge);
    xHist.SetMaximum(xMax+xEdge);
    xHist.SetLineColor(1);
    xHist.DrawCopy("E");

    TH1F lHist("lHist", (name+(" Min")), nStep, 0.0, dT);
    minTS->getData(nStep, pData);
    for (int i=0 ; i<nStep ; i++) {
        lHist.SetBinContent(i+1, pData[i]);
	// lHist.SetBinError(i+1, 0.0);
    }
    lHist.SetLineColor(2);
    lHist.DrawCopy("SAME");

    TH1F hHist("hHist", (name+(" Max")), nStep, 0.0, dT);
    maxTS->getData(nStep, pData);
    for (int i=0 ; i<nStep ; i++) {
        hHist.SetBinContent(i+1, pData[i]);
        // hHist.SetBinError(i+1, 0.0);
    }
    hHist.SetLineColor(3);
    hHist.DrawCopy("SAME");

    //---------------------------------  Clean up and go away
    delete[] pData;
    if (tIn == &In) {
	tIn->rmChannel( (name+".n").Data());
	tIn->rmChannel( (name+".rms").Data());
        tIn->rmChannel( (name+".mean").Data());
	tIn->rmChannel( (name+".min").Data());
	tIn->rmChannel( (name+".max").Data());
    } else {
        delete tIn;
    }
    delete meanTS;
    delete minTS;
    delete maxTS;
    delete countTS;
    delete rmsTS;
}
