#include "SinGauss.hh"
#include <iostream>

using namespace std;

namespace generator {

  SinGauss::SinGauss(void) {
      setTriggerRate(1.0);
      setParameter("A",     1.0);
      setParameter("F",     1.0);
      setParameter("Q",     1.0);
      setParameter("Phi",   0.0);
      setParameter("Width", 6.0);
  }

  SinGauss::SinGauss(double Amp, double Freq, double Q, double Phi, double w)
  {
      setTriggerRate(1.0);
      setParameter("A",     Amp);
      setParameter("F",     Freq);
      setParameter("Q",     Q);
      setParameter("Phi",   Phi);
      setParameter("Width", w);
  }

  SinGauss::~SinGauss(void) {
  }

  SinGauss*
  SinGauss::clone(void) const {
      return new SinGauss(*this);
  }

  //====================================  Generate sine-gaussian time-series
  void
  SinGauss::getSeries(const Time& t0, Interval dT, int N, gen_sample_type* d) {

      //--------------------------------  Get the parameters
      double Ampl  = getNumeric("A");
      double omega = 2*M_PI*getNumeric("F");
      double Q     = getNumeric("Q");
      double Phi   = getNumeric("Phi")*M_PI/180.0;
      double Width = getNumeric("Width");
      double sigma = Q/omega;
      double twoSigmaSq = 2.0*sigma*sigma;

      //-------------------------------  Set up to loop
      double xWid  = Width*sigma;
      double xInc  = dT;
      double xLow  = double(t0 - getTrigTime());
      for (int i=0 ; i<N ; ++i) {
	  double x = xLow + i*xInc;
	  if (x + xWid < 0) continue;
	  if (x > xWid) break;
	  d[i] += Ampl * sin(omega*x + Phi) * exp(-x*x/twoSigmaSq);
      }
  }

  //====================================  Get the full width (2*Width*sigma)
  Interval
  SinGauss::getDuration(void) const {
      double Freq  = getNumeric("F");
      double Q     = getNumeric("Q");
      double Width = getNumeric("Width");
      double omega = 2*M_PI*Freq;
      return Interval(2*Width*Q/omega);
  }

} // namespace generator
