//
//    Skeleton Frame processing routine Template
//
#include <time.h>
#include <iostream>
#include <stdlib.h>
#include "DMTemplate.hh"

//-------------------------------------  Generate the main routine.
EXECDMT(DMTemplate)

//-------------------------------------  Skeleton object constructor.
DMTemplate::DMTemplate(int argc, const char *argv[]) 
  : DMTBase(argc, argv), MaxFrame(999999)
{
    for (int i=1 ; i<argc ; i++) {
        if (!strcmp("MaxFrame", argv[i])) {
	    MaxFrame = strtol(argv[++i], 0, 0);
	}
    }
}

//-------------------------------------  Skeleton object destructor.
DMTemplate::~DMTemplate() 
{
    std::cout << "DMTemplate: Total Frames processed =" << getNFrames() << std::endl;
}

//-------------------------------------  Frame processing function.
void
DMTemplate::ProcessFrame(DMTBase::frame_ptr_type frame) 
{
    int NFrames = getNFrames();
    std::cout << "DMTemplate::ProcessFrame(CPP): Frame " << NFrames << std::endl;
    if (NFrames >= MaxFrame) finish();
}
