#include "CalibChan.hh"
#include <stdexcept>

using namespace std;

//======================================  CalibChanList constructor
CalibChanList::CalibChanList(const std::string& Chan) {
    if (!Chan.empty()) setChannel(Chan);
}

//======================================  CalibChanList destructor
CalibChanList::~CalibChanList(void) {
}

//======================================  Specify a channel a build name list
void
CalibChanList::setChannel(const std::string& chan) {
    mSensing.clear();
    mResponse.clear();
    mOLoopGain.clear();
    mCavFac.clear();
    mOLoopFac.clear();

    string::size_type l = chan.size();
    if (l<7 || chan.substr(2,5) != ":LSC-") 
        throw runtime_error("Invalid channel name");
    string pfx  = chan.substr(0,3) + "CAL-";
    mOLoopGain = pfx + "OLOOP_GAIN";
    string sufx = string("_") + chan.substr(7);
    mSensing  = pfx + "CAV_GAIN"  + sufx;
    mResponse = pfx + "RESPONSE"  + sufx;
    mCavFac   = pfx + "CAV_FAC";
    mOLoopFac = pfx + "OLOOP_FAC";
}
