#ifndef ONLFRIO_H
#define ONLFRIO_H
//
//   Frame input/output functions.
//
#ifndef DMTOFFLINE
class LSMP_CON;
#endif

struct FrIO {
  typedef unsigned int uint_t;
  enum {null, online, file} mode;
  int         fd;
  #ifndef DMTOFFLINE
  LSMP_CON*   consumer;
  #endif
  const char* bufptr;
  uint_t      inx;
  uint_t      end;
  bool        gethdr;
};

extern "C" {
  struct FrIO *FrIOOpenR(char* filename);
  struct FrIO *FrIOOpenW(char *filename);
  int FrIOClose(struct FrIO *fd);
  int FrIOWrite(struct FrIO *fd, char* buf, int nbyte);
  int FrIORead(struct FrIO *fd, char* buf, int nbyte);
  int FrIOSet(struct FrIO *frfd, long offset);
  int FrIOSetFromEnd(struct FrIO *frfd, long offset);
  int FrIOSetFromCur(struct FrIO *frfd, long offset);
  long FrIOTell(struct FrIO *frfd);
}
#endif // ONLFRIO_H
