#include "Offset.hh"
#include "Time.hh"
#include "constant.hh"
#include <math.h>

//-------------------------------------  Offset Constructor. 
Offset::Offset(double offset, const Interval& dT, const Time& t0)
  : mT0(t0), mTc(t0), mAmpl(offset)
{
    mTl = t0 + dT;
}

//-------------------------------------  Frequency domain template bin.
fComplex 
Offset::Fspace(double Freq, double dF) const {
    if ((Freq <= 0) && (Freq + dF > 0)) {
       return fComplex (mAmpl, 0);
    }
    else {
       return fComplex (0, 0);
    }
}

//-------------------------------------  Time domain template bin.
double 
Offset::Tspace(const Time& t0) const {
    return Ampl(t0);
}

//-------------------------------------  Get the t0.
Time 
Offset::getT0(void) const {
    return mT0;
}

//-------------------------------------  Get the End time.
Time
Offset::getTEnd(void) const {
    return mTl;
}

//-------------------------------------  Get the Critical time.
Time
Offset::getTc(void) const {
    return mTc;
}

//-------------------------------------  Time versus Frequency.
Time
Offset::TvsF(double f) const {
    return mT0;
}

//-------------------------------------  Amplitude.
double 
Offset::Ampl(const Time& t) const {
    return mAmpl;
}

void
Offset::setAmp(double amp) {
    mAmpl = amp;
}
