/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef SEG_IOTEXT_HH
#define SEG_IOTEXT_HH

#include "seg_iobase.hh"

/**  The seg_iotext class reads and writes segments to/from an text file 
  *  (aLigo format?).
  *  \brief Segment list I/O.
  *  \author John Zweizig
  *  \version 1.0; last modified July 27, 2011
  */
class seg_iotext : public seg_iobase {
public:

    /**  Default constructor for a segment reader.
      *  \brief Default constructor
      */ 
    seg_iotext(void);

    /**  Destructor for an text segment reader.
      *  \brief Destructor
      */ 
    ~seg_iotext(void);

    /**  Read the specified segment(s) from the input text file. The segments 
      *  specified with \a select are read in from the file.
      *  If the name, ifo or version field of \a select is empty, all segments
      *  matching the non-empty fields are read in. If the input file does not
      *  specify the segment name, ifo  or version, the requested name, ifo
      *  and version are used. The \a format string is used to specify column
      *  contents and contains colon-separated content specifiers. A double
      *  colon indicates the corresponding column is to be ignored. If the 
      *  format is empty, read_seg will attempt to infer the column contents.
      *  \brief read segments from a file.
      *  \param file   Input file name.
      *  \param select Segments to be read.
      *  \param format File format, \e e.g "n:s:e:d".
      */
    void read_seg(const std::string& file, const segID& select, 
		  const std::string& format="");

    /**  Write selected segment list(s) from the specified map to a text file.
      *  Segments matching the \a select specifier are written to the output
      *  file. If any field of the select segID is empty, all lists matching 
      *  the non-empty fields are written. The format specifies the output
      *  string and may include the folowing escape characters
      *  <table>
      *  <tr><td>\%d</td><td>Segment duration</td></tr>
      *  <tr><td>\%e</td><td>End GPS time</td></tr>
      *  <tr><td>\%f</td><td>Full segment name</td></tr>
      *  <tr><td>\%n</td><td>Segment name</td></tr>
      *  <tr><td>\%s</td><td>Start GPS time</td></tr>
      *  <tr><td>\%v</td><td>Version number</td></tr>
      *  </table>
      *  \brief Write selected segment list(s).
      *  \param smap   Segment map containing the segment list(s) to be written.
      *  \param select Segment ID used to select segment list(s) to be written.
      *  \param format Format specifier.
      *  \param file   Output file path.
      */
    void write_seg(const seg_map& smap, const segID& select, 
		   const std::string& format, const std::string& file);

private:
};

#endif // !defined(SEG_IOTEXT_HH)
