#ifndef _LIGO_EVENTTYPEINFO_H
#define _LIGO_EVENTTYPEINFO_H
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: TypeInfo						*/
/*                                                         		*/
/* Module Description: Event type information				*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 1.0	 25Jun01  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: TypeInfo.html					*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1999.			*/
/*                                                         		*/
/*                                                         		*/
/* Caltech				MIT		   		*/
/* LIGO Project MS 51-33		LIGO Project NW-17 161		*/
/* Pasadena CA 91125			Cambridge MA 01239 		*/
/*                                                         		*/
/* LIGO Hanford Observatory		LIGO Livingston Observatory	*/
/* P.O. Box 1970 S9-02			19100 LIGO Lane Rd.		*/
/* Richland WA 99352			Livingston, LA 70754		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/
#ifndef __CINT__
#include <string>
#include "events/Type.hh"
#include "events/IndexList.hh"


namespace events {

   class LayoutInfo;


/** Defines the event type information (internal use).

    @memo Defines the event type information
    @author Written June 2001 by Masahiro Ito and Daniel Sigg
    @version 1.0
 ************************************************************************/
   class TypeInfo {
      friend class Factory;
   public:
      /// Constructor
      TypeInfo (int id, const char* name);
   
      /// Get the Id
      int GetId() const {
         return mId; }
      /// Get the name
      const char* GetName() const {
         return mName.c_str(); }
      /** Reference counting.
          @memo Reference counting
   	  @param sub ID
       ******************************************************************/
      void RefCount (bool up = true);
      /** Get the the layout information record.
          @memo Get layout information
   	  @return layout information record
       ******************************************************************/
      const LayoutInfo* GetLayout () const {
         return mLayout; }
   
   private:
      /// In use count
      int		mInUse;
      /// Type ID
      int		mId;
      /// Type name
      std::string	mName;
      /// Layout pointer
      mutable const LayoutInfo*	mLayout;
   
      /** Set the the layout information record.
          @memo Set layout information
   	  @return layout information record
       ******************************************************************/
      void SetLayout (const LayoutInfo* linfo) const {
         mLayout = linfo; }
   };


/** @name TypeList
    A list of type information records.
    @memo  A list of type information records
    @author Written June 2001 by Masahiro Ito and Daniel Sigg
    @version 1.0
 ************************************************************************/
//@{
   /// Type smart pointer
   typedef IndexEntryPtr<TypeInfo> TypePtr;
   /// List of type information
   typedef IndexList <TypePtr> TypeList;
//@}


}
#endif // __CINT__
#endif // _LIGO_EVENTTYPEINFO_H
