//////////////////////////////////////////////////////////////////////////
//  									//
//  Name								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include <iostream>
#include "events/Name.hh"
#include "events/Factory.hh"

namespace events {

//______________________________________________________________________________
   Name::Name (int id) 
   : mId (id) { 
      if (!GetName()) {
         mId = 0;
      }
   }

//______________________________________________________________________________
   bool Name::SetName (const char* name) 
   {
      mId = 0;
      return Factory::Get().RegisterName (name, mId);
   }

//______________________________________________________________________________
   const char* Name::GetName() const
   {
      return Factory::Get().GetNameStr (mId);
   }

//______________________________________________________________________________
   int Name::GetNameId (const char* name)
   {
      return Factory::Get().GetNameId (name);
   }

//______________________________________________________________________________
   bool Name::Test (const char* name)
   {
      return Factory::Get().GetNameId (name) != 0;
   }

//______________________________________________________________________________
   bool Name::Match (const char* pat) const
   {
      return Factory::Get().MatchName (*this, pat);
   }

//______________________________________________________________________________
   bool Name::CheckName (const char* name)
   {
      return Factory::Get().CheckNameName (name);
   }

//______________________________________________________________________________
   void Name::DumpAll (std::ostream& os)
   {
      Factory::Get().DumpAllNames (os);
   }

//______________________________________________________________________________
   void Name::DumpAll() 
   {
      DumpAll (std::cout);
   }

}
