//////////////////////////////////////////////////////////////////////////
//  									//
//  Iterator								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include "events/Iterator.hh"
#include "events/Events.hh"
#include "events/Set.hh"

namespace std {

//______________________________________________________________________________
   insert_iterator_Set& 
   insert_iterator_Set::operator= (
                     const events::Event& value) 
   {
      mContainer->Insert (value);
      return *this; 
   }

//______________________________________________________________________________
   back_insert_iterator_Set& 
   back_insert_iterator_Set::operator= (
                     const events::Event& value) 
   {
      mContainer->PushBack (value);
      return *this; 
   }

//______________________________________________________________________________
   insert_iterator_Chain& 
   insert_iterator_Chain::operator= (
                     const events::Event& value) 
   {
      mContainer->Insert (value);
      return *this; 
   }

//______________________________________________________________________________
   back_insert_iterator_Chain& 
   back_insert_iterator_Chain::operator= (
                     const events::Event& value) 
   {
      mContainer->PushBack (value);
      return *this; 
   }

//______________________________________________________________________________
   insert_iterator_List& 
   insert_iterator_List::operator= (
                     const events::Event& value) 
   {
      mContainer->Insert (value);
      return *this; 
   }

//______________________________________________________________________________
   back_insert_iterator_List& 
   back_insert_iterator_List::operator= (
                     const events::Event& value) 
   {
      mContainer->PushBack (value);
      return *this; 
   }


}
