/* -*- mode: c++; c-basic-offset: 3; -*- */
//////////////////////////////////////////////////////////////////////////
//  									//
//  Filter								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include <string.h>
#include <strings.h>
#include <cstdlib>
#include <string>
#include "events/Filter.hh"
#include "events/Argument.hh"


namespace events {

//______________________________________________________________________________
   bool Filter::operator== (const Filter& filter) const
   {
      return (mIndex == filter.mIndex) &&
         (strcasecmp (mPattern.c_str(), filter.mPattern.c_str()) == 0);
   }

//______________________________________________________________________________
   bool Filter::IsValid() const
   {
      return (strlen (mColumn.GetName()) == 0) || mColumn.IsValid();
   }

//______________________________________________________________________________
   bool Filter::Evaluate (const Argument& arg, bool& val) const
   {
      val = true;
      if (mIndex < 0) {
         for (int i = 0; i < arg.GetOrder(); ++i) {
            const Event* event = mColumn.GetEvent (arg, i);
            if (!Match (event)) {
               val = false;
               break;
            }
         }
      }
      else {
         const Event* event = mColumn.GetEvent (arg, mIndex);
         if (!Match (event)) {
            val = false;
         }
      }
      return true;
   }

//______________________________________________________________________________
   bool Filter::Match (const Event* event) const 
   {
      // Valid event?
      if (!event) {
         return false;
      }
      // Get type of event
      Type type;
      if (!event->GetLayout().GetType (type)) {
         return false; 
      }
      Name name = event->GetName();
      // Match type
      switch (mTypeMatch) {
         case kExact: 
            { 
               // compare type numbers
               if (type != mType) {
                  return false;
               }
               break;
            }
         case kAll: 
            {
               // no test for type necessary
               break;
            }
         case kWildcard: 
            {
               // compare strings
               if (!type.Match (mTypePat.c_str())) {
                  return false;
               }
               break;
            }
      }
      // Match name
      switch (mNameMatch) {
         case kExact: 
            { 
               // compare type numbers
               return (name == mName);
            }
         case kAll: 
            {
               // no test for type necessary
               return true;
            }
         case kWildcard: 
            {
               // compare strings
               return name.Match (mNamePat.c_str());
            }
      }
      return true;
   }

//______________________________________________________________________________
   bool Filter::SetPattern (const char* pattern)
   {
      // Init parameters
      mIndex = -1;
      mPattern = "";
      mColumn.SetName (0);
      mTypePat = "";
      mNamePat = "";
      mTypeMatch = kExact;
      mNameMatch = kExact;
      mType.SetType (0);
      mName.SetName (0);
      // Check if valid pattern
      if (!pattern || (strlen (pattern) == 0)) {
         return true;
      }
      // Eliminate space
      mPattern = pattern;
      std::string::size_type pos;
      while ((pos = mPattern.find_first_of (" \t\f\n\r\v")) != 
            std::string::npos) {
         mPattern.erase (pos, 1);
      }
      // Check for index
      if ((pos = mPattern.find ('[')) != std::string::npos) {
         mIndex = atoi (mPattern.c_str() + pos + 1);
         mPattern.erase (pos);
      }
      // separate out event column array indices
      std::string colname;
      if (mPattern.find_first_of (".(") != std::string::npos) {
         if ((pos = mPattern.find_last_of ('.')) != std::string::npos) {
            colname = mPattern.substr (0, pos + 1);
            mPattern.erase (pos + 1);
         }   
         if ((pos = mPattern.find ('(')) != std::string::npos) {
            colname += "Event";
            colname += mPattern.substr (pos);
            mPattern.erase (pos);
         }
      }
      // set column
      mColumn.SetName (colname);
      // Set type and subtype pattern
      if ((pos = mPattern.find ("::")) == std::string::npos) {
         mTypePat = mPattern;
         mNamePat = "*";
      }
      else {
         mTypePat = mPattern.substr (0, pos);
         mNamePat = mPattern.substr (pos + 2);
      }
      // Set matching
      if (mTypePat == "*") {
         mTypeMatch = kAll;
      }
      else if (mTypePat.find_first_of ("*?") != std::string::npos) {
         mTypeMatch = kWildcard;
      }
      else {
         mTypeMatch = kExact;
      }
      if (mNamePat == "*") {
         mNameMatch = kAll;
      }
      else if (mNamePat.find_first_of ("*?") != std::string::npos) {
         mNameMatch = kWildcard;
      }
      else {
         mNameMatch = kExact;
      }
      // Set type
      if (mTypeMatch == kExact) {
         mType.SetType (mTypePat.c_str());
      }
      // Set name
      if (mNameMatch == kExact) {
         mName.SetName (mNamePat.c_str());
      }
      // Add columns to pattern again
      mPattern = mColumn.GetName() + mPattern;
      return IsValid();
   }


}
