/* -*- mode: c++; c-basic-offset: 3; -*- */
//////////////////////////////////////////////////////////////////////////
//  									//
//  Column								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include <time.h>
#include <cstdlib>
#include <cstring>
#include "events/Column.hh"
#include "events/ColumnCache.hh"
#include "events/Event.hh"
#include "events/Argument.hh"
#include "events/Value.hh"


namespace events {

//______________________________________________________________________________
   Column::~Column()
   {
      if (mCache) delete mCache;
   }

//______________________________________________________________________________
   Column& Column::operator= (const Column& col)
   {
      if (this != &col) {
         mName = col.mName;
         mIndex = col.mIndex;
         if (mCache) delete mCache;
         mCache = col.mCache ? col.mCache->Copy() : 0;
      }
      return *this;
   }

//______________________________________________________________________________
   bool Column::IsValid() const
   {
      return mCache && (mCache->IsValid());
   }

//______________________________________________________________________________
   bool Column::Get (const Event& event, Value& val) const
   {
      if (!mCache) {
         return false;
      }
      return mCache->Get (event, val);
   }

//______________________________________________________________________________
   bool Column::Set (Event& event, const Value& val)
   {
      if (!mCache) {
         return false;
      }
      return mCache->Set (event, val);
   }

//______________________________________________________________________________
   Event* Column::GetEvent (Event& event)
   {
      if (!mCache) {
         return &event;
      }
      return mCache->GetEvent (event);
   }

//______________________________________________________________________________
   const Event* Column::GetEvent (const Event& event) const
   {
      if (!mCache) {
         return &event;
      }
      return ((const ColumnCache*)mCache)->GetEvent (event);
   }

//______________________________________________________________________________
   const Event* Column::GetEvent (const Argument& arg, int index) const
   {
      if ((index < 0) || (index >= arg.GetOrder())) {
         return NULL;
      }
      return GetEvent (arg (index));
   }

//______________________________________________________________________________
   bool Column::Evaluate (const Argument& arg, Value& val) const
   {
      if ((mIndex < 0) || (mIndex >= arg.GetOrder())) {
         return false;
      }
      return Get (arg (mIndex), val);
   }

//______________________________________________________________________________
   void Column::SetName (const char* name)
   {
      mName = "";
      mIndex = 0;
      if (mCache) delete mCache;
      mCache = 0;
      if (!name || (strlen (name) == 0)) {
         return;
      }
      // Check for index
      mName = name;
      std::string::size_type pos;
      if ((pos = mName.find ('[')) != std::string::npos) {
         mIndex = atoi (mName.c_str() + pos + 1);
         mName.erase (pos);
      }
      // create new column cache
      mCache = new (std::nothrow) ColumnCache (mName.c_str());
      if (mCache && mCache->IsValid()) {
         mName = mCache->GetName(); // canonical name!
      }
   }

//______________________________________________________________________________
   void Column::ResetCache() const 
   {
      if (mCache) mCache->Reset();
   }

}
