/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    TrigPar  Manage a parameter database.
//
#include "TrigPar.hh"
#include <fstream>
#include "Param.hh"

using namespace std;

//--------------------------------------  Construct a parameter dictionary
TrigPar::TrigPar(const char* file) {
    ifstream istr(file, ios::in);
    Read(istr);
    istr.close();
}

TrigPar::TrigPar(istream& istr) {
    Read(istr);
}

//======================================  Destroy a parameter dictionary
TrigPar::~TrigPar(void) {
    for (map_iter i=mParSet.begin(); i != mParSet.end(); ++i) {
	delete i->second;
    }
}

//--------------------------------------  See if a parameter exists
bool
TrigPar::exists(const string& ParName) const {
    return mParSet.find(ParName) != mParSet.end();
}

//--------------------------------------  Read in a parameter set.
void 
TrigPar::Read(istream& istr, const string& prefix) {
    string Line, Name, Type;
    while (!istr.eof()) {
        istr >> Line;
	int inx = Line.find(":");
	Name = Line.substr(0, inx);
	inx++;
	int len = Line.substr(inx).find(":");
	Type = Line.substr(inx,len);
	inx += len + 1;
	addPar(prefix+Name, Type.c_str(), Line.c_str()+inx);
    }
}

//    Get functions.
int 
TrigPar::getInt(const string& ParName) const {
    const_map_iter iter = mParSet.find(ParName);
    if (iter == mParSet.end()) return 0;
    const Param* par  = iter->second;
    return int(*par);
}

double 
TrigPar::getDouble(const string& ParName) const {
    const_map_iter iter = mParSet.find(ParName);
    if (iter == mParSet.end()) return 0.0;
    const Param* par  = iter->second;
    return double(*par);
}

string 
TrigPar::getString(const string& ParName) const {
    const_map_iter iter = mParSet.find(ParName);
    if (iter == mParSet.end()) return string("");
    const Param* par  = iter->second;
    return par->cvtstring();
}

//---------------------------------------  AddPar functions
void 
TrigPar::addPar(const string& ParName, int ipar) {
    mParSet[ParName] = new param_int(ipar);
}

void 
TrigPar::addPar(const string& ParName, double dpar) {
    mParSet[ParName] = new param_double(dpar);
}

void 
TrigPar::addPar(const string& ParName, const string& spar) {
    mParSet[ParName] = new param_string(spar);
}

void 
TrigPar::addPar(const string& Name, const char *Type, const char *Value) {
    if (!Value) Value = "";
    switch(*Type) {
    case 'i':
        mParSet[Name] = new param_int(Value);
	break;
    case 'f':
    case 'd':
        mParSet[Name] = new param_double(Value);
	break;
    case 's':
        mParSet[Name] = new param_string(Value);
	break;
    default:
        break;
    }
}

//---------------------------------------  remove function
void
TrigPar::remove(const string& Name) {
    map_iter ipar = mParSet.find(Name);
    if (ipar == mParSet.end()) return;
    Param* pptr = ipar->second;
    mParSet.erase(ipar);
    delete pptr;
}

//---------------------------------------  setPar functions
void 
TrigPar::setPar(const string& ParName, int ipar) {
    *mParSet[ParName] = ipar;
}

void 
TrigPar::setPar(const string& ParName, double dpar) {
    *mParSet[ParName] = dpar;
}

void 
TrigPar::setPar(const string& ParName, const string& spar) {
    *mParSet[ParName] = spar;
}

ostream&
TrigPar::Write(ostream& ostr, const string& prefix) const {
    int lpfx = prefix.length();
    for (const_map_iter i = mParSet.begin() ; i != mParSet.end() ; ++i) {
        if (lpfx && (prefix != i->first.substr(0,lpfx))) continue;
        ostr << (*i).first.substr(lpfx) << ":" << (*i).second->getType() 
	     << ":" << (i->second)->cvtstring() << endl;
    }
    return ostr;
}



