/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "Tukey.hh"
#include "constant.hh"
#include <cmath>

//======================================  Constructor
Tukey::Tukey(double frac, int N) 
  : mFrac(frac)
{
    if (N) setWindow(N);
}

//======================================  Destructor
Tukey::~Tukey(void) {
}

//======================================  Clone
Tukey* 
Tukey::clone(void) const {
    return new Tukey(mFrac);
}

//======================================  Generate Tukey
double 
Tukey::WinFc(double arg) {
    double pifrac = pi * mFrac;
    double piarg  = arg - pi;
    double x;
    if (fabs(piarg) < pifrac) x = 0.0;
    else if (piarg < 0)       x = (piarg + pifrac) / (1.0 - mFrac);
    else                      x = (piarg - pifrac) / (1.0 - mFrac);
    return 0.5 * (1 + cos(x));
}
