#ifndef DACC_FCPP_HH
#define DACC_FCPP_HH

#ifndef __CINT__
#include "framecpp/Types.hh"
#else
namespace FrameCPP {
  class FrameH;
  class FrAdcData;
  class FrDetector;
  class FrProcData;
  class FrRawData;
  class FrSimData;
  class FrStatData;
  class FrVect;

  namespace Common {
    class FrStatData;
  }
}
#endif  // !def(__CINT__)

#include "ldas/ldasconfig.hh"
#ifndef LDAS_VERSION_NUMBER
#define LDAS_VERSION_NUMBER 109000
#endif

#if !defined(__CINT__) && (LDAS_VERSION_NUMBER > 119010)
#define FCPP_SHARED_PTRS 1
  #if LDAS_VERSION_NUMBER < 200000
    #include "general/SharedPtr.hh"
    typedef General::SharedPtr<FrameCPP::FrameH>     frameh_pointer;
    typedef General::SharedPtr<FrameCPP::FrDetector> frdetector_pointer;
    typedef General::SharedPtr<FrameCPP::FrRawData>  frrawdata_pointer;
    typedef General::SharedPtr<FrameCPP::FrAdcData>  fradcdata_pointer;
    typedef General::SharedPtr<FrameCPP::FrProcData> frprocdata_pointer;
    typedef General::SharedPtr<FrameCPP::FrSimData>  frsimdata_pointer;
    typedef General::SharedPtr<FrameCPP::Common::FrStatData> frstatdata_pointer;
    typedef General::SharedPtr<FrameCPP::FrVect>     frvect_pointer;
  #else
    #include "ldastoolsal/SharedPtr.hh"
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrameH>     frameh_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrDetector> frdetector_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrRawData>  frrawdata_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrAdcData>  fradcdata_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrProcData> frprocdata_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrSimData>  frsimdata_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::Common::FrStatData> frstatdata_pointer;
    typedef LDASTools::AL::SharedPtr<FrameCPP::FrVect>     frvect_pointer;
  #endif
#else
  typedef FrameCPP::FrameH*     frameh_pointer;
  typedef FrameCPP::FrDetector* frdetector_pointer;
  typedef FrameCPP::FrRawData*  frrawdata_pointer;
  typedef FrameCPP::FrAdcData*  fradcdata_pointer;
  typedef FrameCPP::FrProcData* frprocdata_pointer;
  typedef FrameCPP::FrSimData*  frsimdata_pointer;
  typedef FrameCPP::Common::FrStatData* frstatdata_pointer;
  typedef FrameCPP::FrVect*     frvect_pointer;
#endif

#endif // !defined(DACC_FCPP_HH)
